/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.bonitasoft.engine.api.APIAccessor;
import org.bonitasoft.engine.api.ApiAccessType;
import org.bonitasoft.engine.api.CommandAPI;
import org.bonitasoft.engine.api.EJB2ServerAPI;
import org.bonitasoft.engine.api.EJB3ServerAPI;
import org.bonitasoft.engine.api.HTTPServerAPI;
import org.bonitasoft.engine.api.IdentityAPI;
import org.bonitasoft.engine.api.LoginAPI;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.ProfileAPI;
import org.bonitasoft.engine.api.TCPServerAPI;
import org.bonitasoft.engine.api.impl.ClientInterceptor;
import org.bonitasoft.engine.api.impl.LocalServerAPIFactory;
import org.bonitasoft.engine.api.internal.ServerAPI;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.Session;
import org.bonitasoft.engine.util.APITypeManager;

public final class TenantAPIAccessor {
    private static ServerAPI getServerAPI() throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        ApiAccessType apiType = APITypeManager.getAPIType();
        Map<String, String> parameters = null;
        switch (apiType) {
            case LOCAL: {
                return LocalServerAPIFactory.getServerAPI();
            }
            case EJB3: {
                parameters = APITypeManager.getAPITypeParameters();
                return new EJB3ServerAPI(parameters);
            }
            case EJB2: {
                parameters = APITypeManager.getAPITypeParameters();
                return new EJB2ServerAPI(parameters);
            }
            case HTTP: {
                parameters = APITypeManager.getAPITypeParameters();
                return new HTTPServerAPI(parameters);
            }
            case TCP: {
                parameters = APITypeManager.getAPITypeParameters();
                return new TCPServerAPI(parameters);
            }
        }
        throw new UnknownAPITypeException("Unsupported API Type: " + (Object)((Object)apiType));
    }

    public static void refresh() {
        APITypeManager.refresh();
    }

    private static <T> T getAPI(Class<T> clazz, APISession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        ServerAPI serverAPI = TenantAPIAccessor.getServerAPI();
        ClientInterceptor sessionInterceptor = new ClientInterceptor(clazz.getName(), serverAPI, (Session)session);
        return (T)Proxy.newProxyInstance(APIAccessor.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)sessionInterceptor);
    }

    private static <T> T getAPI(Class<T> clazz) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        ServerAPI serverAPI = TenantAPIAccessor.getServerAPI();
        ClientInterceptor sessionInterceptor = new ClientInterceptor(clazz.getName(), serverAPI);
        return (T)Proxy.newProxyInstance(APIAccessor.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)sessionInterceptor);
    }

    public static LoginAPI getLoginAPI() throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getAPI(LoginAPI.class);
    }

    public static IdentityAPI getIdentityAPI(APISession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getAPI(IdentityAPI.class, session);
    }

    public static ProcessAPI getProcessAPI(APISession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getAPI(ProcessAPI.class, session);
    }

    public static CommandAPI getCommandAPI(APISession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getAPI(CommandAPI.class, session);
    }

    public static ProfileAPI getProfileAPI(APISession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getAPI(ProfileAPI.class, session);
    }
}

