/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.BusinessObjectModel;
import org.bonitasoft.engine.bdm.model.Query;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.BusinessObjectModelValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.BusinessObjectValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.FieldValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.IndexValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.MultipleAggregationToItselfValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.QueryParameterValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.QueryValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.SimpleFieldValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.UniqueConstraintValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.UniqueSimpleNameValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.composition.AggregationAndCompositionValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.composition.CyclicCompositionValidationRule;
import org.bonitasoft.engine.bdm.validator.rule.composition.UniquenessCompositionValidationRule;

public class BusinessObjectModelValidator {
    private final List<ValidationRule<?, ValidationStatus>> rules = new ArrayList();

    public BusinessObjectModelValidator() {
        this.rules.add(new BusinessObjectModelValidationRule());
        this.rules.add(new BusinessObjectValidationRule());
        this.rules.add(new FieldValidationRule());
        this.rules.add(new SimpleFieldValidationRule());
        this.rules.add(new UniqueConstraintValidationRule());
        this.rules.add(new IndexValidationRule());
        this.rules.add(new QueryValidationRule());
        this.rules.add(new QueryParameterValidationRule());
        this.rules.add(new MultipleAggregationToItselfValidationRule());
        this.rules.add(new UniquenessCompositionValidationRule());
        this.rules.add(new CyclicCompositionValidationRule());
        this.rules.add(new AggregationAndCompositionValidationRule());
        this.rules.add(new UniqueSimpleNameValidationRule());
    }

    public ValidationStatus validate(BusinessObjectModel bom) {
        Set<Object> objectsToValidate = this.buildModelTree(bom);
        ValidationStatus status = new ValidationStatus();
        for (Object modelElement : objectsToValidate) {
            for (ValidationRule<?, ValidationStatus> rule : this.rules) {
                if (!rule.appliesTo(modelElement)) continue;
                status.addValidationStatus(rule.checkRule(modelElement));
            }
        }
        return status;
    }

    private Set<Object> buildModelTree(BusinessObjectModel bom) {
        HashSet<Object> objectsToValidate = new HashSet<Object>();
        objectsToValidate.add(bom);
        for (BusinessObject bo : bom.getBusinessObjects()) {
            objectsToValidate.add(bo);
            objectsToValidate.addAll(bo.getFields());
            List uniqueConstraints = bo.getUniqueConstraints();
            objectsToValidate.addAll(uniqueConstraints);
            List queries = bo.getQueries();
            for (Query q : queries) {
                objectsToValidate.add(q);
                objectsToValidate.addAll(q.getQueryParameters());
            }
            objectsToValidate.addAll(bo.getIndexes());
        }
        return objectsToValidate;
    }

    public List<ValidationRule<?, ValidationStatus>> getRules() {
        return Collections.unmodifiableList(this.rules);
    }
}

