/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.business.application;

import org.bonitasoft.engine.business.application.ApplicationVisibility;

public enum InternalProfiles {
    INTERNAL_PROFILE_SUPER_ADMIN("_BONITA_INTERNAL_PROFILE_SUPER_ADMIN", ApplicationVisibility.TECHNICAL_USER),
    INTERNAL_PROFILE_ALL("_BONITA_INTERNAL_PROFILE_ALL", ApplicationVisibility.ALL);

    private final String profileName;
    private final ApplicationVisibility applicationVisibility;

    private InternalProfiles(String profileName, ApplicationVisibility applicationVisibility) {
        this.profileName = profileName;
        this.applicationVisibility = applicationVisibility;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public ApplicationVisibility getApplicationVisibility() {
        return this.applicationVisibility;
    }

    public static ApplicationVisibility getApplicationVisibilityByProfileName(String profileName) {
        for (InternalProfiles internalProfile : InternalProfiles.values()) {
            if (!internalProfile.getProfileName().equals(profileName)) continue;
            return internalProfile.applicationVisibility;
        }
        return ApplicationVisibility.RESTRICTED;
    }

    public static InternalProfiles getInternalProfileByProfileName(String profileName) {
        for (InternalProfiles internalProfile : InternalProfiles.values()) {
            if (!internalProfile.getProfileName().equals(profileName)) continue;
            return internalProfile;
        }
        return null;
    }
}

