/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.digest;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.bonitasoft.engine.api.Internal;

@Internal
public class DigestUtils {
    public static String encodeBase64AsUtf8String(byte[] bytes) {
        return new String(Base64.getEncoder().encode(bytes), StandardCharsets.UTF_8);
    }

    public static byte[] md5(String source) {
        return DigestUtils.digest("MD5", source);
    }

    public static byte[] sha1(String source) {
        return DigestUtils.digest("SHA1", source);
    }

    private static byte[] digest(String algorithm, String source) {
        return DigestUtils.getDigest(algorithm).digest(DigestUtils.utf8Bytes(source));
    }

    private static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static byte[] utf8Bytes(String string) {
        if (string == null) {
            return null;
        }
        return string.getBytes(StandardCharsets.UTF_8);
    }
}

