/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileOperations {
    private FileOperations() {
    }

    public static byte[] getFileFromZip(File zip, String filePath) throws IOException {
        try (ZipFile zipFile = new ZipFile(zip);){
            byte[] byArray;
            block12: {
                ZipEntry entry = zipFile.getEntry(filePath);
                if (entry == null) {
                    throw new FileNotFoundException(String.format("'%s' not found in %s", filePath, zip.getName()));
                }
                InputStream is = zipFile.getInputStream(entry);
                try {
                    byArray = is.readAllBytes();
                    if (is == null) break block12;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return byArray;
        }
    }

    public static void updateFileContent(File zip, String filePath, InputStream newContent) throws IOException {
        Path zipFilePath = zip.toPath();
        try (FileSystem fs = FileSystems.newFileSystem(zipFilePath, (ClassLoader)null);){
            Path source = fs.getPath(filePath, new String[0]);
            Path temp = fs.getPath("./temp_" + UUID.randomUUID().toString(), new String[0]);
            Files.write(temp, newContent.readAllBytes(), StandardOpenOption.CREATE_NEW);
            Files.move(temp, source, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static String read(File file) throws IOException {
        return Files.readString(file.toPath(), StandardCharsets.UTF_8);
    }

    public static byte[] readFully(File file) throws IOException {
        return Files.readAllBytes(file.toPath());
    }

    public static byte[] readFully(InputStream in) throws IOException {
        int n;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((n = in.read(buf)) > 0) {
            out.write(buf, 0, n);
        }
        return out.toByteArray();
    }

    public static boolean isBarFile(String fileName) {
        return fileName.endsWith(".bar");
    }

    public static boolean isXmlFile(String fileName) {
        return fileName.endsWith(".xml");
    }

    public static boolean isZipFile(File file) {
        return file.getName().endsWith(".zip");
    }

    public static InputStream asInputStream(byte[] bytes) {
        return new ByteArrayInputStream(bytes);
    }

    public static InputStream asInputStream(String content) {
        return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
    }

    public static InputStream resource(String name) {
        return FileOperations.class.getResourceAsStream(name);
    }

    public static byte[] resourceAsBytes(String name) throws IOException {
        return FileOperations.resource(name).readAllBytes();
    }
}

