/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class IOUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zip(String fileName, byte[] fileContent) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        try {
            zos.putNextEntry(new ZipEntry(fileName));
            zos.write(fileContent);
        }
        finally {
            zos.closeEntry();
            zos.close();
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, byte[]> unzip(byte[] zippedContent) throws IOException {
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zippedContent));
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        try {
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = zis.read(buffer)) > 0) {
                        baos.write(buffer, 0, len);
                    }
                }
                resources.put(entry.getName(), baos.toByteArray());
                entry = zis.getNextEntry();
            }
        }
        finally {
            zis.closeEntry();
            zis.close();
        }
        return resources;
    }

    public static File createTempDirectory(String prefix) throws IOException {
        File tmpDirectory = File.createTempFile(prefix, null);
        return IOUtils.createDirectory(tmpDirectory);
    }

    public static File createSubDirectory(File directory, String child) {
        File subDir = new File(directory, child);
        return IOUtils.createDirectory(subDir);
    }

    public static File createDirectoryIfNotExists(File dir) {
        if (!dir.exists()) {
            return IOUtils.createDirectory(dir);
        }
        return dir;
    }

    private static File createDirectory(File dir) {
        dir.delete();
        dir.mkdir();
        return dir;
    }

    public static void saveDocument(Document document, File destination) throws IOException, TransformerException {
        if (document == null) {
            throw new IllegalArgumentException("Document should not be null.");
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Transformer tf = transformerFactory.newTransformer();
        tf.setOutputProperty("encoding", "UTF-8");
        tf.setOutputProperty("indent", "yes");
        try (FileOutputStream fos = new FileOutputStream(destination);){
            StreamResult outputTarget = new StreamResult(fos);
            tf.transform(new DOMSource(document), outputTarget);
        }
    }

    public static File createTempFile(String name, String suffix, byte[] content) throws IOException {
        return Files.write(Files.createTempFile(name, suffix, new FileAttribute[0]), content, new OpenOption[0]).toFile();
    }
}

