/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveContribution;

public class ExternalResourceContribution
implements BusinessArchiveContribution {
    public static final String EXTERNAL_RESOURCE_FOLDER = "resources";

    @Override
    public boolean readFromBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        File externalResourceFolder = new File(barFolder, EXTERNAL_RESOURCE_FOLDER);
        if (externalResourceFolder.exists() && !externalResourceFolder.isFile()) {
            return this.readFromFileOrFolder(businessArchive, externalResourceFolder, null) > 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readFromFileOrFolder(BusinessArchive businessArchive, File fileOrFolder, String parentFolder) throws FileNotFoundException, IOException {
        if (fileOrFolder.isFile()) {
            FileChannel ch = null;
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(fileOrFolder);
                ch = fin.getChannel();
                int size = (int)ch.size();
                MappedByteBuffer buf = ch.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                byte[] bytes = new byte[size];
                buf.get(bytes);
                businessArchive.addResource(parentFolder + "/" + fileOrFolder.getName(), bytes);
                ch = null;
                int n = 1;
                return n;
            }
            finally {
                if (fin != null) {
                    fin.close();
                }
                if (ch != null) {
                    ch.close();
                }
            }
        }
        if (fileOrFolder.isDirectory()) {
            int nb = 0;
            for (File file : fileOrFolder.listFiles()) {
                String parentFolder2 = fileOrFolder.getName();
                if (parentFolder != null) {
                    parentFolder2 = parentFolder + "/" + fileOrFolder.getName();
                }
                nb += this.readFromFileOrFolder(businessArchive, file, parentFolder2);
            }
            return nb;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveToBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        File externalResourceFolder = new File(barFolder, EXTERNAL_RESOURCE_FOLDER);
        externalResourceFolder.mkdir();
        int beginIndex = EXTERNAL_RESOURCE_FOLDER.length();
        Map<String, byte[]> resources = businessArchive.getResources("^resources/.*$");
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        for (Map.Entry<String, byte[]> entry : resources.entrySet()) {
            try {
                File fullPathFile = new File(externalResourceFolder, entry.getKey().substring(beginIndex));
                fullPathFile.getParentFile().mkdirs();
                fos = new FileOutputStream(fullPathFile);
                bos = new BufferedOutputStream(fos);
                bos.write(entry.getValue());
            }
            finally {
                if (bos != null) {
                    bos.close();
                } else if (fos != null) {
                    fos.close();
                }
            }
            fos = null;
            bos = null;
        }
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public String getName() {
        return EXTERNAL_RESOURCE_FOLDER;
    }
}

