/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.bind.ValidationException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveContribution;
import org.bonitasoft.engine.bpm.bar.InvalidBusinessArchiveFormatException;
import org.bonitasoft.engine.bpm.bar.xml.ActorDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.ActorInitiatorDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.AutomaticTaskDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.BoundaryEventDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.CallActivityDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.CallableElementBinding;
import org.bonitasoft.engine.bpm.bar.xml.CallableElementVersionBinding;
import org.bonitasoft.engine.bpm.bar.xml.CatchErrorEventTriggerDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.CatchMessageEventTriggerDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.CatchSignalEventTriggerDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.ConditionalExpressionBinding;
import org.bonitasoft.engine.bpm.bar.xml.ConnectorDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.ConnectorDefinitionInputBinding;
import org.bonitasoft.engine.bpm.bar.xml.CorrelationBinding;
import org.bonitasoft.engine.bpm.bar.xml.CorrelationKeyBinding;
import org.bonitasoft.engine.bpm.bar.xml.CorrelationValueBinding;
import org.bonitasoft.engine.bpm.bar.xml.DataDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.DataInputOperationBinding;
import org.bonitasoft.engine.bpm.bar.xml.DataOutputOperationBinding;
import org.bonitasoft.engine.bpm.bar.xml.DefaultTransitionDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.DefaultValueBinding;
import org.bonitasoft.engine.bpm.bar.xml.DisplayDescriptionAfterCompletionExpressionBinding;
import org.bonitasoft.engine.bpm.bar.xml.DisplayDescriptionExpressionBinding;
import org.bonitasoft.engine.bpm.bar.xml.DisplayNameExpressionBinding;
import org.bonitasoft.engine.bpm.bar.xml.DocumentDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.EndEventDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.ExpressionBinding;
import org.bonitasoft.engine.bpm.bar.xml.FlowElementBinding;
import org.bonitasoft.engine.bpm.bar.xml.GatewayDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.IncomingTransitionRefBinding;
import org.bonitasoft.engine.bpm.bar.xml.IntermediateCatchEventBinding;
import org.bonitasoft.engine.bpm.bar.xml.IntermediateThrowEventDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.LeftOperandBinding;
import org.bonitasoft.engine.bpm.bar.xml.LoopConditionBinding;
import org.bonitasoft.engine.bpm.bar.xml.LoopMaxBinding;
import org.bonitasoft.engine.bpm.bar.xml.ManualTaskDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.MultiInstanceCompletionConditionBinding;
import org.bonitasoft.engine.bpm.bar.xml.MultiInstanceLoopCardinalityBinding;
import org.bonitasoft.engine.bpm.bar.xml.MultiInstanceLoopCharacteristicsBinding;
import org.bonitasoft.engine.bpm.bar.xml.OperationBinding;
import org.bonitasoft.engine.bpm.bar.xml.OutgoingTransitionRefBinding;
import org.bonitasoft.engine.bpm.bar.xml.ParameterDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.ProcessDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.ReceiveTaskDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.RightOperandBinding;
import org.bonitasoft.engine.bpm.bar.xml.SendTaskDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.StandardLoopCharacteristicsBinding;
import org.bonitasoft.engine.bpm.bar.xml.StartEventDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.StringIndexBinding;
import org.bonitasoft.engine.bpm.bar.xml.SubProcessDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.TargetFlowNodeBinding;
import org.bonitasoft.engine.bpm.bar.xml.TargetProcessBinding;
import org.bonitasoft.engine.bpm.bar.xml.TerminateEventTriggerDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.TextDataDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.ThrowErrorEventTriggerDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.ThrowMessageEventTriggerDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.ThrowSignalEventTriggerDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.TimerEventTriggerDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.TransitionDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.UserFilterDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.UserTaskDefinitionBinding;
import org.bonitasoft.engine.bpm.bar.xml.XMLProcessDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.FlowElementContainerDefinition;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.io.IOUtil;
import org.bonitasoft.engine.io.xml.ElementBinding;
import org.bonitasoft.engine.io.xml.InvalidSchemaException;
import org.bonitasoft.engine.io.xml.XMLHandler;
import org.bonitasoft.engine.io.xml.XMLNode;
import org.bonitasoft.engine.io.xml.XMLParseException;

public class ProcessDefinitionBARContribution
implements BusinessArchiveContribution {
    public static final String PROCESS_DEFINITION_XML = "process-design.xml";
    public static final String PROCESS_INFOS_FILE = "process-infos.txt";
    private XMLHandler handler;

    public ProcessDefinitionBARContribution() {
        ArrayList<Class<? extends ElementBinding>> bindings = new ArrayList<Class<? extends ElementBinding>>();
        bindings.add(ProcessDefinitionBinding.class);
        bindings.add(ActorDefinitionBinding.class);
        bindings.add(ActorInitiatorDefinitionBinding.class);
        bindings.add(UserTaskDefinitionBinding.class);
        bindings.add(ManualTaskDefinitionBinding.class);
        bindings.add(AutomaticTaskDefinitionBinding.class);
        bindings.add(ReceiveTaskDefinitionBinding.class);
        bindings.add(SendTaskDefinitionBinding.class);
        bindings.add(TransitionDefinitionBinding.class);
        bindings.add(GatewayDefinitionBinding.class);
        bindings.add(DefaultTransitionDefinitionBinding.class);
        bindings.add(ConnectorDefinitionBinding.class);
        bindings.add(ConnectorDefinitionInputBinding.class);
        bindings.add(UserFilterDefinitionBinding.class);
        bindings.add(ParameterDefinitionBinding.class);
        bindings.add(StartEventDefinitionBinding.class);
        bindings.add(StringIndexBinding.class);
        bindings.add(IntermediateCatchEventBinding.class);
        bindings.add(BoundaryEventDefinitionBinding.class);
        bindings.add(TimerEventTriggerDefinitionBinding.class);
        bindings.add(EndEventDefinitionBinding.class);
        bindings.add(ExpressionBinding.class);
        bindings.add(ConditionalExpressionBinding.class);
        bindings.add(DataDefinitionBinding.class);
        bindings.add(TextDataDefinitionBinding.class);
        bindings.add(DocumentDefinitionBinding.class);
        bindings.add(DefaultValueBinding.class);
        bindings.add(DisplayDescriptionAfterCompletionExpressionBinding.class);
        bindings.add(DisplayDescriptionExpressionBinding.class);
        bindings.add(DisplayNameExpressionBinding.class);
        bindings.add(OutgoingTransitionRefBinding.class);
        bindings.add(IncomingTransitionRefBinding.class);
        bindings.add(CatchMessageEventTriggerDefinitionBinding.class);
        bindings.add(OperationBinding.class);
        bindings.add(RightOperandBinding.class);
        bindings.add(LeftOperandBinding.class);
        bindings.add(ThrowMessageEventTriggerDefinitionBinding.class);
        bindings.add(CatchSignalEventTriggerDefinitionBinding.class);
        bindings.add(ThrowSignalEventTriggerDefinitionBinding.class);
        bindings.add(IntermediateThrowEventDefinitionBinding.class);
        bindings.add(CatchErrorEventTriggerDefinitionBinding.class);
        bindings.add(ThrowErrorEventTriggerDefinitionBinding.class);
        bindings.add(CorrelationBinding.class);
        bindings.add(CorrelationKeyBinding.class);
        bindings.add(CorrelationValueBinding.class);
        bindings.add(StandardLoopCharacteristicsBinding.class);
        bindings.add(MultiInstanceLoopCharacteristicsBinding.class);
        bindings.add(LoopConditionBinding.class);
        bindings.add(LoopMaxBinding.class);
        bindings.add(MultiInstanceLoopCardinalityBinding.class);
        bindings.add(MultiInstanceCompletionConditionBinding.class);
        bindings.add(CallActivityDefinitionBinding.class);
        bindings.add(DataInputOperationBinding.class);
        bindings.add(DataOutputOperationBinding.class);
        bindings.add(CallableElementBinding.class);
        bindings.add(CallableElementVersionBinding.class);
        bindings.add(TerminateEventTriggerDefinitionBinding.class);
        bindings.add(TargetProcessBinding.class);
        bindings.add(TargetFlowNodeBinding.class);
        bindings.add(SubProcessDefinitionBinding.class);
        bindings.add(FlowElementBinding.class);
        InputStream schemaStream = ProcessDefinitionBARContribution.class.getResourceAsStream("ProcessDefinition.xsd");
        try {
            this.handler = new XMLHandler(bindings);
            this.handler.setSchema(schemaStream);
        }
        catch (ParserConfigurationException e) {
            throw new BonitaRuntimeException(e);
        }
        catch (InvalidSchemaException e) {
            throw new BonitaRuntimeException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new BonitaRuntimeException(e);
        }
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public boolean readFromBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException, InvalidBusinessArchiveFormatException {
        File file = new File(barFolder, PROCESS_DEFINITION_XML);
        if (!file.exists()) {
            return false;
        }
        DesignProcessDefinition processDefinition = this.deserializeProcessDefinition(file);
        businessArchive.setProcessDefinition(processDefinition);
        this.checkProcessInfos(barFolder, processDefinition);
        return true;
    }

    protected void checkProcessInfos(File barFolder, DesignProcessDefinition processDefinition) throws InvalidBusinessArchiveFormatException {
        String processInfos = this.getProcessInfos(this.generateInfosFromDefinition(processDefinition));
        try {
            String fileContent = IOUtil.read(new File(barFolder, PROCESS_INFOS_FILE));
            if (!processInfos.equals(fileContent.trim())) {
                throw new InvalidBusinessArchiveFormatException("Invalid Business Archive format");
            }
        }
        catch (IOException e) {
            throw new InvalidBusinessArchiveFormatException("Invalid Business Archive format");
        }
    }

    public DesignProcessDefinition deserializeProcessDefinition(File file) throws IOException, InvalidBusinessArchiveFormatException {
        Object objectFromXML;
        try {
            this.handler.validate(file);
            objectFromXML = this.handler.getObjectFromXML(file);
        }
        catch (XMLParseException e) {
            throw new InvalidBusinessArchiveFormatException(e);
        }
        catch (ValidationException e) {
            throw new InvalidBusinessArchiveFormatException((Exception)((Object)e));
        }
        if (objectFromXML instanceof DesignProcessDefinition) {
            return (DesignProcessDefinition)objectFromXML;
        }
        throw new InvalidBusinessArchiveFormatException("the file did not contain a process but: " + objectFromXML);
    }

    @Override
    public void saveToBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        DesignProcessDefinition processDefinition = businessArchive.getProcessDefinition();
        this.serializeProcessDefinition(barFolder, processDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeProcessDefinition(File barFolder, DesignProcessDefinition processDefinition) throws IOException {
        try {
            FileOutputStream fout = new FileOutputStream(new File(barFolder, PROCESS_DEFINITION_XML));
            try {
                XMLNode rootNode = new XMLProcessDefinition().getXMLProcessDefinition(processDefinition);
                this.handler.write(rootNode, fout);
            }
            finally {
                fout.close();
            }
            String infos = this.generateInfosFromDefinition(processDefinition);
            IOUtil.write(new File(barFolder, PROCESS_INFOS_FILE), this.getProcessInfos(infos));
        }
        catch (FileNotFoundException e) {
            throw new IOException(e);
        }
    }

    protected String generateInfosFromDefinition(DesignProcessDefinition processDefinition) {
        FlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
        return "key1:" + processDefinition.getActorsList().size() + ",key2:" + processContainer.getTransitions().size() + ",key3:" + processContainer.getActivities().size();
    }

    protected String getProcessInfos(String infos) {
        return Base64.encodeBase64String((byte[])DigestUtils.md5((String)infos)).trim();
    }

    @Override
    public String getName() {
        return "Process design";
    }
}

