/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveContribution;

public abstract class ResourceInSpecificFolderContribution
implements BusinessArchiveContribution {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readFromBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        File folder = new File(barFolder, this.getFolderName());
        if (folder.exists() && !folder.isFile()) {
            File[] listFiles = folder.listFiles();
            FileChannel ch = null;
            FileInputStream fin = null;
            for (File file : listFiles) {
                try {
                    fin = new FileInputStream(file);
                    ch = fin.getChannel();
                    int size = (int)ch.size();
                    MappedByteBuffer buf = ch.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                    byte[] bytes = new byte[size];
                    buf.get(bytes);
                    businessArchive.addResource(this.getFolderName() + '/' + file.getName(), bytes);
                }
                finally {
                    if (fin != null) {
                        fin.close();
                    }
                    if (ch != null) {
                        ch.close();
                    }
                }
                ch = null;
                fin = null;
            }
            return listFiles.length > 0;
        }
        return false;
    }

    protected abstract String getFolderName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveToBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        File folder = new File(barFolder, this.getFolderName());
        folder.mkdir();
        int beginIndex = this.getFolderName().length();
        Map<String, byte[]> resources = businessArchive.getResources("^" + this.getFolderName() + "/.*$");
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        for (Map.Entry<String, byte[]> entry : resources.entrySet()) {
            try {
                fos = new FileOutputStream(new File(folder, entry.getKey().substring(beginIndex)));
                bos = new BufferedOutputStream(fos);
                bos.write(entry.getValue());
            }
            finally {
                if (bos != null) {
                    bos.close();
                } else if (fos != null) {
                    fos.close();
                }
            }
            fos = null;
            bos = null;
        }
    }

    @Override
    public boolean isMandatory() {
        return false;
    }
}

