/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar.xml;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.bpm.bar.xml.FlowNodeDefinitionBinding;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.flownode.BoundaryEventDefinition;
import org.bonitasoft.engine.bpm.flownode.LoopCharacteristics;
import org.bonitasoft.engine.bpm.flownode.impl.ActivityDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.FlowNodeDefinitionImpl;
import org.bonitasoft.engine.operation.Operation;

public abstract class ActivityDefinitionBinding
extends FlowNodeDefinitionBinding {
    protected final List<DataDefinition> dataDefinitions = new ArrayList<DataDefinition>();
    protected final List<Operation> operations = new ArrayList<Operation>();
    protected LoopCharacteristics loopCharacteristics;
    private final List<BoundaryEventDefinition> boundaryEventDefinitions = new ArrayList<BoundaryEventDefinition>(1);

    @Override
    public void setChildObject(String name, Object value) {
        super.setChildObject(name, value);
        if ("dataDefinition".equals(name)) {
            this.dataDefinitions.add((DataDefinition)value);
        }
        if ("textDataDefinition".equals(name)) {
            this.dataDefinitions.add((DataDefinition)value);
        }
        if ("xmlDataDefinition".equals(name)) {
            this.dataDefinitions.add((DataDefinition)value);
        }
        if ("operation".equals(name)) {
            this.operations.add((Operation)value);
        }
        if ("standardLoopCharacteristics".equals(name) || "multiInstanceLoopCharacteristics".equals(name)) {
            this.loopCharacteristics = (LoopCharacteristics)value;
        }
        if ("boundaryEvent".equals(name)) {
            this.boundaryEventDefinitions.add((BoundaryEventDefinition)value);
        }
    }

    @Override
    protected void fillNode(FlowNodeDefinitionImpl flowNode) {
        super.fillNode(flowNode);
        if (flowNode instanceof ActivityDefinitionImpl) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)flowNode;
            for (DataDefinition dataDefinition : this.dataDefinitions) {
                activity.addDataDefinition(dataDefinition);
            }
            for (Operation operation : this.operations) {
                activity.addOperation(operation);
            }
            activity.setLoopCharacteristics(this.loopCharacteristics);
            for (BoundaryEventDefinition boundaryEvent : this.boundaryEventDefinitions) {
                activity.addBoundaryEventDefinition(boundaryEvent);
            }
        }
    }
}

