/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.bpm.bar.xml.NamedElementBinding;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.flownode.TransitionDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.FlowNodeDefinitionImpl;
import org.bonitasoft.engine.expression.Expression;

public abstract class FlowNodeDefinitionBinding
extends NamedElementBinding {
    protected final List<ConnectorDefinition> connectors = new ArrayList<ConnectorDefinition>();
    protected final List<TransitionDefinition> incomingTransitions = new ArrayList<TransitionDefinition>();
    protected final List<TransitionDefinition> outgoingTransitions = new ArrayList<TransitionDefinition>();
    private TransitionDefinition defaultTransition;
    private Expression displayName;
    private Expression displayDescription;
    private Expression displayDescriptionAfterCompletion;

    @Override
    public void setChildElement(String name, String value, Map<String, String> attributes) {
    }

    @Override
    public void setChildObject(String name, Object value) {
        if ("displayName".equals(name)) {
            this.displayName = (Expression)value;
        }
        if ("displayDescription".equals(name)) {
            this.displayDescription = (Expression)value;
        }
        if ("displayDescriptionAfterCompletion".equals(name)) {
            this.displayDescriptionAfterCompletion = (Expression)value;
        }
        if ("connector".equals(name)) {
            this.connectors.add((ConnectorDefinition)value);
        }
        if ("incomingTransition".equals(name)) {
            this.incomingTransitions.add((TransitionDefinition)value);
        }
        if ("outgoingTransition".equals(name)) {
            this.outgoingTransitions.add((TransitionDefinition)value);
        }
        if ("defaultTransition".equals(name)) {
            this.defaultTransition = (TransitionDefinition)value;
        }
    }

    protected void fillNode(FlowNodeDefinitionImpl flowNode) {
        flowNode.setDescription(this.description);
        flowNode.setDisplayName(this.displayName);
        flowNode.setDisplayDescriptionAfterCompletion(this.displayDescriptionAfterCompletion);
        flowNode.setDisplayDescription(this.displayDescription);
        for (ConnectorDefinition connector : this.connectors) {
            flowNode.addConnector(connector);
        }
        for (TransitionDefinition transition : this.incomingTransitions) {
            flowNode.addIncomingTransition(transition);
        }
        for (TransitionDefinition transition : this.outgoingTransitions) {
            flowNode.addOutgoingTransition(transition);
        }
        flowNode.setDefaultTransition(this.defaultTransition);
    }
}

