/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.flownode.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.bpm.BaseElement;
import org.bonitasoft.engine.bpm.BaseElementImpl;
import org.bonitasoft.engine.bpm.NamedElement;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.document.DocumentDefinition;
import org.bonitasoft.engine.bpm.flownode.ActivityDefinition;
import org.bonitasoft.engine.bpm.flownode.BoundaryEventDefinition;
import org.bonitasoft.engine.bpm.flownode.EndEventDefinition;
import org.bonitasoft.engine.bpm.flownode.FlowNodeDefinition;
import org.bonitasoft.engine.bpm.flownode.GatewayDefinition;
import org.bonitasoft.engine.bpm.flownode.IntermediateCatchEventDefinition;
import org.bonitasoft.engine.bpm.flownode.IntermediateThrowEventDefinition;
import org.bonitasoft.engine.bpm.flownode.StartEventDefinition;
import org.bonitasoft.engine.bpm.flownode.TransitionDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.FlowElementContainerDefinition;

public class FlowElementContainerDefinitionImpl
extends BaseElementImpl
implements FlowElementContainerDefinition {
    private static final long serialVersionUID = 1L;
    private final List<ActivityDefinition> activities = new ArrayList<ActivityDefinition>();
    private final Set<TransitionDefinition> transitions = new HashSet<TransitionDefinition>();
    private final List<GatewayDefinition> gateways = new ArrayList<GatewayDefinition>();
    private final List<StartEventDefinition> startEvents = new ArrayList<StartEventDefinition>(1);
    private final List<IntermediateCatchEventDefinition> intermediateCatchEvents = new ArrayList<IntermediateCatchEventDefinition>(4);
    private final List<IntermediateThrowEventDefinition> intermediateThrowEvents;
    private final List<EndEventDefinition> endEvents = new ArrayList<EndEventDefinition>(4);
    private final List<DataDefinition> dataDefinitions;
    private final List<DocumentDefinition> documentDefinitions;
    private final List<ConnectorDefinition> connectors;
    private final Map<String, FlowNodeDefinition> flowNodes;

    public FlowElementContainerDefinitionImpl() {
        this.intermediateThrowEvents = new ArrayList<IntermediateThrowEventDefinition>(4);
        this.dataDefinitions = new ArrayList<DataDefinition>();
        this.documentDefinitions = new ArrayList<DocumentDefinition>();
        this.connectors = new ArrayList<ConnectorDefinition>();
        this.flowNodes = new HashMap<String, FlowNodeDefinition>();
    }

    @Override
    public FlowNodeDefinition getFlowNode(long sourceId) {
        Set<FlowNodeDefinition> flowNodes = this.getFlowNodes();
        return this.getElementById(flowNodes, sourceId);
    }

    @Override
    public FlowNodeDefinition getFlowNode(String sourceName) {
        Set<FlowNodeDefinition> flowNodes = this.getFlowNodes();
        return this.getElementByName(flowNodes, sourceName);
    }

    private Set<FlowNodeDefinition> getFlowNodes() {
        HashSet<FlowNodeDefinition> flowNodes = new HashSet<FlowNodeDefinition>();
        flowNodes.addAll(this.gateways);
        flowNodes.addAll(this.activities);
        flowNodes.addAll(this.startEvents);
        flowNodes.addAll(this.intermediateCatchEvents);
        flowNodes.addAll(this.intermediateThrowEvents);
        flowNodes.addAll(this.endEvents);
        flowNodes.addAll(this.getBoundaryEvents());
        return Collections.unmodifiableSet(flowNodes);
    }

    private List<BoundaryEventDefinition> getBoundaryEvents() {
        ArrayList<BoundaryEventDefinition> boundaryEvents = new ArrayList<BoundaryEventDefinition>(3);
        for (ActivityDefinition activity : this.activities) {
            boundaryEvents.addAll(activity.getBoundaryEventDefinitions());
        }
        return boundaryEvents;
    }

    @Override
    public List<ActivityDefinition> getActivities() {
        return Collections.unmodifiableList(this.activities);
    }

    @Override
    public ActivityDefinition getActivity(String name) {
        return this.getElementByName(this.activities, name);
    }

    @Override
    public Set<TransitionDefinition> getTransitions() {
        return Collections.unmodifiableSet(this.transitions);
    }

    @Override
    @Deprecated
    public Set<GatewayDefinition> getGateways() {
        return Collections.unmodifiableSet(new HashSet<GatewayDefinition>(this.gateways));
    }

    @Override
    public List<GatewayDefinition> getGatewaysList() {
        return Collections.unmodifiableList(this.gateways);
    }

    @Override
    public GatewayDefinition getGateway(String name) {
        return this.getElementByName(this.gateways, name);
    }

    private <T extends BaseElement> T getElementById(Collection<T> elements, long id) {
        BaseElement element = null;
        boolean found = false;
        Iterator<T> iterator = elements.iterator();
        while (!found && iterator.hasNext()) {
            BaseElement next = (BaseElement)iterator.next();
            if (next.getId() != id) continue;
            found = true;
            element = next;
        }
        return (T)element;
    }

    private <T extends NamedElement> T getElementByName(Collection<T> elements, String name) {
        NamedElement element = null;
        boolean found = false;
        Iterator<T> iterator = elements.iterator();
        while (!found && iterator.hasNext()) {
            NamedElement next = (NamedElement)iterator.next();
            if (!name.equals(next.getName())) continue;
            found = true;
            element = next;
        }
        return (T)element;
    }

    @Override
    public List<StartEventDefinition> getStartEvents() {
        return Collections.unmodifiableList(this.startEvents);
    }

    @Override
    public List<IntermediateCatchEventDefinition> getIntermediateCatchEvents() {
        return Collections.unmodifiableList(this.intermediateCatchEvents);
    }

    @Override
    public List<IntermediateThrowEventDefinition> getIntermediateThrowEvents() {
        return Collections.unmodifiableList(this.intermediateThrowEvents);
    }

    @Override
    public List<EndEventDefinition> getEndEvents() {
        return Collections.unmodifiableList(this.endEvents);
    }

    @Override
    public List<DataDefinition> getDataDefinitions() {
        return Collections.unmodifiableList(this.dataDefinitions);
    }

    @Override
    public List<DocumentDefinition> getDocumentDefinitions() {
        return Collections.unmodifiableList(this.documentDefinitions);
    }

    @Override
    public List<ConnectorDefinition> getConnectors() {
        return Collections.unmodifiableList(this.connectors);
    }

    public void addActivity(ActivityDefinition activity) {
        this.activities.add(activity);
        this.flowNodes.put(activity.getName(), activity);
    }

    public void addTransition(TransitionDefinition transition) {
        this.transitions.add(transition);
    }

    public void addGateway(GatewayDefinition gateway) {
        this.gateways.add(gateway);
        this.flowNodes.put(gateway.getName(), gateway);
    }

    public void addStartEvent(StartEventDefinition startEvent) {
        this.startEvents.add(startEvent);
        this.flowNodes.put(startEvent.getName(), startEvent);
    }

    public void addIntermediateCatchEvent(IntermediateCatchEventDefinition event) {
        this.intermediateCatchEvents.add(event);
        this.flowNodes.put(event.getName(), event);
    }

    public void addIntermediateThrowEvent(IntermediateThrowEventDefinition intermediateThrowEvent) {
        this.intermediateThrowEvents.add(intermediateThrowEvent);
        this.flowNodes.put(intermediateThrowEvent.getName(), intermediateThrowEvent);
    }

    public void addEndEvent(EndEventDefinition endEvent) {
        this.endEvents.add(endEvent);
        this.flowNodes.put(endEvent.getName(), endEvent);
    }

    public void addDataDefinition(DataDefinition dataDefinition) {
        this.dataDefinitions.add(dataDefinition);
    }

    public void addDocumentDefinition(DocumentDefinition documentDefinition) {
        this.documentDefinitions.add(documentDefinition);
    }

    public void addConnector(ConnectorDefinition connectorDefinition) {
        this.connectors.add(connectorDefinition);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.activities == null ? 0 : this.activities.hashCode());
        result = 31 * result + (this.connectors == null ? 0 : this.connectors.hashCode());
        result = 31 * result + (this.dataDefinitions == null ? 0 : this.dataDefinitions.hashCode());
        result = 31 * result + (this.documentDefinitions == null ? 0 : this.documentDefinitions.hashCode());
        result = 31 * result + (this.endEvents == null ? 0 : this.endEvents.hashCode());
        result = 31 * result + (this.gateways == null ? 0 : this.gateways.hashCode());
        result = 31 * result + (this.intermediateCatchEvents == null ? 0 : this.intermediateCatchEvents.hashCode());
        result = 31 * result + (this.intermediateThrowEvents == null ? 0 : this.intermediateThrowEvents.hashCode());
        result = 31 * result + (this.startEvents == null ? 0 : this.startEvents.hashCode());
        result = 31 * result + (this.transitions == null ? 0 : this.transitions.hashCode());
        result = 31 * result + (this.flowNodes == null ? 0 : this.flowNodes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlowElementContainerDefinitionImpl other = (FlowElementContainerDefinitionImpl)obj;
        if (this.activities == null ? other.activities != null : !this.activities.equals(other.activities)) {
            return false;
        }
        if (this.connectors == null ? other.connectors != null : !this.connectors.equals(other.connectors)) {
            return false;
        }
        if (this.dataDefinitions == null ? other.dataDefinitions != null : !this.dataDefinitions.equals(other.dataDefinitions)) {
            return false;
        }
        if (this.documentDefinitions == null ? other.documentDefinitions != null : !this.documentDefinitions.equals(other.documentDefinitions)) {
            return false;
        }
        if (this.endEvents == null ? other.endEvents != null : !this.endEvents.equals(other.endEvents)) {
            return false;
        }
        if (this.gateways == null ? other.gateways != null : !this.gateways.equals(other.gateways)) {
            return false;
        }
        if (this.intermediateCatchEvents == null ? other.intermediateCatchEvents != null : !this.intermediateCatchEvents.equals(other.intermediateCatchEvents)) {
            return false;
        }
        if (this.intermediateThrowEvents == null ? other.intermediateThrowEvents != null : !this.intermediateThrowEvents.equals(other.intermediateThrowEvents)) {
            return false;
        }
        if (this.startEvents == null ? other.startEvents != null : !this.startEvents.equals(other.startEvents)) {
            return false;
        }
        if (this.transitions == null ? other.transitions != null : !this.transitions.equals(other.transitions)) {
            return false;
        }
        return !(this.flowNodes == null ? other.flowNodes != null : !this.flowNodes.equals(other.flowNodes));
    }
}

