/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class BonitaException
extends Exception {
    private static final long serialVersionUID = -5413586694735909486L;
    private int[] causesPositions;

    public BonitaException(String message) {
        super(message);
    }

    public BonitaException(String message, Throwable cause) {
        super(message);
        this.mergeStacks(cause);
    }

    public BonitaException(Throwable cause) {
        super(cause.getMessage());
        this.mergeStacks(cause);
    }

    protected int[] getCausesPositions() {
        return this.causesPositions;
    }

    private void mergeStacks(Throwable cause) {
        if (cause == null) {
            return;
        }
        StackTraceElement[] currentStack = this.getStackTrace();
        ArrayList<StackTraceElement[]> causesStacks = new ArrayList<StackTraceElement[]>();
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        Throwable subCause = cause;
        int causeslength = 0;
        do {
            StackTraceElement[] stackTrace = subCause.getStackTrace();
            causesStacks.add(stackTrace);
            exceptions.add(subCause);
            causeslength += stackTrace.length + 1;
        } while ((subCause = subCause.getCause()) != null);
        StackTraceElement[] mergedStackTrace = new StackTraceElement[currentStack.length + causeslength + 1];
        System.arraycopy(currentStack, 0, mergedStackTrace, 0, currentStack.length);
        this.causesPositions = new int[exceptions.size() + 1];
        this.causesPositions[0] = currentStack.length;
        mergedStackTrace[currentStack.length] = new StackTraceElement("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550", "<server stack trace>", "", -3);
        int current = currentStack.length + 1;
        int i = 0;
        for (StackTraceElement[] stackTraceElements : causesStacks) {
            System.arraycopy(stackTraceElements, 0, mergedStackTrace, current, stackTraceElements.length);
            this.causesPositions[i + 1] = current += stackTraceElements.length;
            mergedStackTrace[current] = new StackTraceElement("", "Caused By:", ((Throwable)exceptions.get(i)).getMessage(), -3);
            ++current;
            ++i;
        }
        this.setStackTrace(mergedStackTrace);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (this.causesPositions != null && this.causesPositions.length > 0) {
            this.printCauses(s);
        } else {
            super.printStackTrace(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printCauses(PrintStream s) {
        boolean printSuper = false;
        PrintStream printStream = s;
        synchronized (printStream) {
            StackTraceElement[] stackTraceElements = this.getStackTrace();
            printSuper = stackTraceElements != null && stackTraceElements.length > 0;
            if (printSuper) {
                for (int j = 0; j <= this.causesPositions[0] - 1; ++j) {
                    s.println("\tat " + stackTraceElements[j]);
                }
                for (int i = 0; i < this.causesPositions.length - 1; ++i) {
                    int n;
                    int startStack1 = i == 0 ? 0 : this.causesPositions[i - 1] + 1;
                    int endStack1 = this.causesPositions[i] - 1;
                    int startStack2 = this.causesPositions[i] + 1;
                    int endStack2 = this.causesPositions[i + 1] - 1;
                    int m = endStack1;
                    for (n = endStack2; m >= startStack1 && n >= startStack2 && stackTraceElements[m].equals(stackTraceElements[n]); --m, --n) {
                    }
                    int framesInCommon = endStack1 - m;
                    if (i == 0) {
                        s.println("Server Exceptions: ");
                    } else {
                        s.println("Caused by: " + this);
                    }
                    for (int j = startStack2; j <= n; ++j) {
                        s.println("\tat " + stackTraceElements[j]);
                    }
                    if (framesInCommon == 0) continue;
                    s.println("\t... " + framesInCommon + " more");
                }
            }
        }
        if (printSuper) {
            super.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (this.causesPositions != null && this.causesPositions.length > 0) {
            this.printCauses(s);
        } else {
            super.printStackTrace(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printCauses(PrintWriter s) {
        boolean printSuper = false;
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            StackTraceElement[] stackTraceElements = this.getStackTrace();
            printSuper = stackTraceElements != null && stackTraceElements.length > 0;
            if (printSuper) {
                for (int j = 0; j <= this.causesPositions[0] - 1; ++j) {
                    s.println("\tat " + stackTraceElements[j]);
                }
                for (int i = 0; i < this.causesPositions.length - 1; ++i) {
                    int n;
                    int startStack1 = i == 0 ? 0 : this.causesPositions[i - 1] + 1;
                    int endStack1 = this.causesPositions[i] - 1;
                    int startStack2 = this.causesPositions[i] + 1;
                    int endStack2 = this.causesPositions[i + 1] - 1;
                    int m = endStack1;
                    for (n = endStack2; m >= startStack1 && n >= startStack2 && stackTraceElements[m].equals(stackTraceElements[n]); --m, --n) {
                    }
                    int framesInCommon = endStack1 - m;
                    s.println("Caused by: " + stackTraceElements[this.causesPositions[i + 1]]);
                    for (int j = startStack2; j <= n; ++j) {
                        s.println("\tat " + stackTraceElements[j]);
                    }
                    if (framesInCommon == 0) continue;
                    s.println("\t... " + framesInCommon + " more");
                }
            }
        }
        if (printSuper) {
            super.printStackTrace(s);
        }
    }

    public StackTraceElement[] getStackTrace(int index) {
        StackTraceElement[] stackTrace = this.getStackTrace();
        int startIndex = index == 0 ? 0 : this.causesPositions[index - 1] + 1;
        int endIndex = index == this.causesPositions.length - 1 ? stackTrace.length - 1 : this.causesPositions[index + 1] - 1;
        return Arrays.copyOfRange(stackTrace, startIndex, endIndex);
    }

    protected String getDefaultMessage() {
        return "";
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (message != null && message.isEmpty() && this.getCause() != null) {
            message = this.getCause().getMessage();
        }
        if (message != null && message.isEmpty()) {
            message = this.getDefaultMessage();
        }
        return message;
    }
}

