/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.exception;

import java.util.ArrayList;

public class BonitaRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -5413586694735909486L;

    public BonitaRuntimeException(String message) {
        super(message);
    }

    public BonitaRuntimeException(String message, Throwable cause) {
        super(message);
        this.mergeStacks(cause);
    }

    public BonitaRuntimeException(Throwable cause) {
        super(cause.getMessage());
        this.mergeStacks(cause);
    }

    private void mergeStacks(Throwable cause) {
        StackTraceElement[] currentStack = this.getStackTrace();
        ArrayList<StackTraceElement[]> causesStacks = new ArrayList<StackTraceElement[]>();
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        Throwable subCause = cause;
        int causeslength = 0;
        do {
            StackTraceElement[] stackTrace = subCause.getStackTrace();
            causesStacks.add(stackTrace);
            exceptions.add(subCause);
            causeslength += stackTrace.length + 1;
        } while ((subCause = subCause.getCause()) != null);
        StackTraceElement[] mergedStackTrace = new StackTraceElement[currentStack.length + causeslength + 1];
        System.arraycopy(currentStack, 0, mergedStackTrace, 0, currentStack.length);
        mergedStackTrace[currentStack.length] = new StackTraceElement("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550", "<server stack trace>", "", -3);
        int current = currentStack.length + 1;
        int i = 0;
        for (StackTraceElement[] stackTraceElements : causesStacks) {
            System.arraycopy(stackTraceElements, 0, mergedStackTrace, current, stackTraceElements.length);
            mergedStackTrace[current += stackTraceElements.length] = new StackTraceElement("", "Caused By:", ((Throwable)exceptions.get(i)).getMessage(), -3);
            ++current;
            ++i;
        }
        this.setStackTrace(mergedStackTrace);
    }
}

