/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.bonitasoft.engine.bpm.document.Document;
import org.bonitasoft.engine.expression.ComparisonOperator;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.ExpressionConstants;
import org.bonitasoft.engine.expression.ExpressionInterpreter;
import org.bonitasoft.engine.expression.ExpressionType;
import org.bonitasoft.engine.expression.InvalidExpressionException;
import org.bonitasoft.engine.expression.XPathReturnType;
import org.bonitasoft.engine.expression.impl.ExpressionImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExpressionBuilder {
    public static final String NOT_EQUALS_COMPARATOR = "!=";
    public static final String NOT_COMPARATOR = "!";
    public static final String LESS_THAN_OR_EQUALS_COMPARATOR = "<=";
    public static final String LESS_THAN_COMPARATOR = "<";
    public static final String GREATER_THAN_OR_EQUALS_COMPARATOR = ">=";
    public static final String GREATER_THAN_COMPARATOR = ">";
    public static final String EQUALS_COMPARATOR = "==";
    private ExpressionImpl expression;
    private static List<String> validOperators = new ArrayList<String>(7);
    private static HashSet<String> numericTypes;

    public ExpressionBuilder createNewInstance(String name) {
        this.expression = new ExpressionImpl();
        this.setName(name);
        return this;
    }

    public Expression createConstantStringExpression(String value) throws InvalidExpressionException {
        this.createNewInstance(value).setContent(value).setExpressionType(ExpressionType.TYPE_CONSTANT.name()).setReturnType(String.class.getName());
        return this.done();
    }

    public Expression createConstantBooleanExpression(boolean value) throws InvalidExpressionException {
        this.createNewInstance(Boolean.toString(value)).setContent(value ? "true" : "false").setExpressionType(ExpressionType.TYPE_CONSTANT.name()).setReturnType(Boolean.class.getName());
        return this.done();
    }

    public Expression createConstantDateExpression(String value) throws InvalidExpressionException {
        this.createNewInstance(value).setContent(String.valueOf(value)).setExpressionType(ExpressionType.TYPE_CONSTANT.name()).setReturnType(Date.class.getName());
        return this.done();
    }

    public Expression createConstantLongExpression(long value) throws InvalidExpressionException {
        this.createNewInstance(Long.toString(value)).setContent(String.valueOf(value)).setExpressionType(ExpressionType.TYPE_CONSTANT.name()).setReturnType(Long.class.getName());
        return this.done();
    }

    public Expression createConstantIntegerExpression(int value) throws InvalidExpressionException {
        this.createNewInstance(Integer.toString(value)).setContent(String.valueOf(value)).setExpressionType(ExpressionType.TYPE_CONSTANT.name()).setReturnType(Integer.class.getName());
        return this.done();
    }

    public Expression createDataExpression(String dataName, String dataType) throws InvalidExpressionException {
        return this.createNewInstance(dataName).setContent(dataName).setExpressionType(ExpressionType.TYPE_VARIABLE.name()).setReturnType(dataType).done();
    }

    public Expression createDocumentReferenceExpression(String documentName) throws InvalidExpressionException {
        return this.createNewInstance(documentName).setContent(documentName).setExpressionType(ExpressionType.TYPE_DOCUMENT.name()).setReturnType(Document.class.getName()).done();
    }

    public Expression createPatternExpression(String dataContent) throws InvalidExpressionException {
        return this.createNewInstance(dataContent).setContent(dataContent).setExpressionType(ExpressionType.TYPE_PATTERN.name()).setReturnType(String.class.getName()).done();
    }

    public Expression createInputExpression(String value, String returnType) throws InvalidExpressionException {
        return this.createNewInstance(value).setContent(value).setExpressionType(ExpressionType.TYPE_INPUT.name()).setReturnType(returnType).done();
    }

    public Expression createAPIAccessorExpression() throws InvalidExpressionException {
        return this.createNewInstance(ExpressionConstants.API_ACCESSOR.getEngineConstantName()).setContent(ExpressionConstants.API_ACCESSOR.getEngineConstantName()).setExpressionType(ExpressionType.TYPE_ENGINE_CONSTANT.name()).setReturnType(ExpressionConstants.API_ACCESSOR.getReturnType()).done();
    }

    public Expression createEngineConstant(ExpressionConstants value) throws InvalidExpressionException {
        return this.createNewInstance(value.getEngineConstantName()).setContent(value.getEngineConstantName()).setExpressionType(ExpressionType.TYPE_ENGINE_CONSTANT.name()).setReturnType(value.getReturnType()).done();
    }

    public Expression done() throws InvalidExpressionException {
        String returnType = this.expression.getReturnType();
        String expName = this.expression.getName();
        String content = this.expression.getContent();
        String expressionType = this.expression.getExpressionType();
        List<Expression> dependencies = this.expression.getDependencies();
        this.generalCheck(returnType, expName, content);
        if (ExpressionType.TYPE_CONDITION.name().equals(expressionType)) {
            this.validateConditionExpression(content, dependencies);
        }
        return this.expression;
    }

    private void validateConditionExpression(String content, List<Expression> dependencies) throws InvalidExpressionException {
        if (!validOperators.contains(content)) {
            throw new InvalidExpressionException("Invalid content for expression of type " + (Object)((Object)ExpressionType.TYPE_CONDITION) + ". The possible values are: " + validOperators);
        }
        if (!NOT_COMPARATOR.equals(content)) {
            if (dependencies.size() != 2) {
                throw new InvalidExpressionException("The comparator " + content + " must have exactly two dependencies. The first one is the left oparand and the second one the right operand.");
            }
            String r1 = dependencies.get(0).getReturnType();
            String r2 = dependencies.get(1).getReturnType();
            if (!(numericTypes.contains(r1) && numericTypes.contains(r2) || r1.equals(r2) || EQUALS_COMPARATOR.equals(content))) {
                throw new InvalidExpressionException("The dependencies of comparator " + content + " must have the same return type.");
            }
        } else {
            if (dependencies.size() != 1) {
                throw new InvalidExpressionException("The logical complement operator " + content + " must have exactly one dependency.");
            }
            if (!dependencies.get(0).getReturnType().equals(Boolean.class.getName())) {
                throw new InvalidExpressionException("The dependency of logical complement operator " + content + " must have the return type " + Boolean.class.getName());
            }
        }
    }

    private void generalCheck(String returnType, String expName, String content) throws InvalidExpressionException {
        if (returnType == null || returnType.isEmpty()) {
            throw new InvalidExpressionException("Expression return type is not set on " + this.expression);
        }
        if (expName == null || expName.isEmpty()) {
            throw new InvalidExpressionException("Expression name is not set on " + this.expression);
        }
        if (content == null) {
            throw new InvalidExpressionException("Expression content is not set on " + this.expression);
        }
    }

    public ExpressionBuilder setContent(String content) {
        this.expression.setContent(content);
        return this;
    }

    public ExpressionBuilder setExpressionType(String expressionType) {
        this.expression.setExpressionType(expressionType);
        return this;
    }

    public ExpressionBuilder setExpressionType(ExpressionType expressionType) {
        this.expression.setExpressionType(expressionType.name());
        return this;
    }

    public ExpressionBuilder setReturnType(String returnType) {
        this.expression.setReturnType(returnType);
        return this;
    }

    public ExpressionBuilder setInterpreter(String interpreter) {
        this.expression.setInterpreter(interpreter);
        return this;
    }

    public ExpressionBuilder setDependencies(List<Expression> dependencies) {
        this.expression.setDependencies(dependencies);
        return this;
    }

    public ExpressionBuilder setName(String name) {
        this.expression.setName(name);
        return this;
    }

    public Expression createExpression(String name, String expressionContent, String returnType, ExpressionType expressionType) throws InvalidExpressionException {
        this.createNewInstance(name).setContent(expressionContent).setExpressionType(expressionType.name()).setReturnType(returnType);
        return this.done();
    }

    public Expression createConstantDoubleExpression(double d) throws InvalidExpressionException {
        this.createNewInstance(Double.toString(d)).setContent(String.valueOf(d)).setExpressionType(ExpressionType.TYPE_CONSTANT.name()).setReturnType(Double.class.getName());
        return this.done();
    }

    public Expression createConstantFloatExpression(float f) throws InvalidExpressionException {
        this.createNewInstance(Float.toString(f)).setContent(String.valueOf(f)).setExpressionType(ExpressionType.TYPE_CONSTANT.name()).setReturnType(Float.class.getName());
        return this.done();
    }

    public Expression createListExpression(String name, List<Expression> expressions) throws InvalidExpressionException {
        this.createNewInstance(name).setContent(name).setExpressionType(ExpressionType.TYPE_LIST.name()).setReturnType(List.class.getName()).setDependencies(expressions);
        return this.done();
    }

    public Expression createListOfListExpression(String name, List<List<Expression>> expressions) throws InvalidExpressionException {
        ArrayList<Expression> deps = new ArrayList<Expression>(expressions.size());
        int i = 0;
        for (List<Expression> list : expressions) {
            String name2 = name + "_" + i++;
            Expression exp = this.createNewInstance(name2).setContent(name2).setExpressionType(ExpressionType.TYPE_LIST.name()).setReturnType(List.class.getName()).setDependencies(list).done();
            deps.add(exp);
        }
        return this.createNewInstance(name).setContent(name).setExpressionType(ExpressionType.TYPE_LIST.name()).setReturnType(List.class.getName()).setDependencies(deps).done();
    }

    public Expression createExpression(String name, String content, String type, String returnType, String interpreter, List<Expression> dependencies) throws InvalidExpressionException {
        this.createNewInstance(name).setContent(content).setExpressionType(type).setReturnType(returnType);
        if (interpreter == null) {
            this.setInterpreter("NONE");
        } else {
            this.setInterpreter(interpreter);
        }
        if (dependencies == null) {
            this.setDependencies(new ArrayList<Expression>());
        } else {
            this.setDependencies(dependencies);
        }
        return this.done();
    }

    public Expression createGroovyScriptExpression(String name, String script, String returnType) throws InvalidExpressionException {
        this.createNewInstance(name).setContent(script).setExpressionType(ExpressionType.TYPE_READ_ONLY_SCRIPT.name()).setInterpreter(ExpressionInterpreter.GROOVY.name()).setReturnType(returnType);
        return this.done();
    }

    public Expression createGroovyScriptExpression(String name, String script, String returnType, List<Expression> dependencies) throws InvalidExpressionException {
        this.createNewInstance(name).setContent(script).setExpressionType(ExpressionType.TYPE_READ_ONLY_SCRIPT.name()).setInterpreter(ExpressionInterpreter.GROOVY.name()).setReturnType(returnType).setDependencies(dependencies);
        return this.done();
    }

    public Expression createGroovyScriptExpression(String name, String script, String returnType, Expression ... dependencies) throws InvalidExpressionException {
        this.createNewInstance(name).setContent(script).setExpressionType(ExpressionType.TYPE_READ_ONLY_SCRIPT.name()).setInterpreter(ExpressionInterpreter.GROOVY.name()).setReturnType(returnType).setDependencies(Arrays.asList(dependencies));
        return this.done();
    }

    public Expression createPatternExpression(String name, String messagePattern, Expression ... dependencies) throws InvalidExpressionException {
        this.createNewInstance(name).setName(messagePattern).setContent(messagePattern).setExpressionType(ExpressionType.TYPE_PATTERN.name()).setInterpreter("NONE").setReturnType(String.class.getName()).setDependencies(Arrays.asList(dependencies));
        return this.done();
    }

    public Expression createParameterExpression(String expressionName, String parameterName, String returnType) throws InvalidExpressionException {
        this.createNewInstance(expressionName).setExpressionType(ExpressionType.TYPE_PARAMETER.name()).setReturnType(returnType).setContent(parameterName);
        return this.done();
    }

    public Expression createComparisonExpression(String name, Expression leftOperand, ComparisonOperator operator, Expression rightOperand) throws InvalidExpressionException {
        String strOperator = null;
        switch (operator) {
            case EQUALS: {
                strOperator = EQUALS_COMPARATOR;
                break;
            }
            case GREATER_THAN: {
                strOperator = GREATER_THAN_COMPARATOR;
                break;
            }
            case GREATER_THAN_OR_EQUALS: {
                strOperator = GREATER_THAN_OR_EQUALS_COMPARATOR;
                break;
            }
            case LESS_THAN: {
                strOperator = LESS_THAN_COMPARATOR;
                break;
            }
            case LESS_THAN_OR_EQUALS: {
                strOperator = LESS_THAN_OR_EQUALS_COMPARATOR;
                break;
            }
            case NOT_EQUALS: {
                strOperator = NOT_EQUALS_COMPARATOR;
            }
        }
        return this.createComparisonExpression(name, leftOperand, strOperator, rightOperand);
    }

    public Expression createComparisonExpression(String name, Expression leftOperand, String operator, Expression rightOperand) throws InvalidExpressionException {
        this.createNewInstance(name).setExpressionType(ExpressionType.TYPE_CONDITION.name()).setReturnType(Boolean.class.getName()).setContent(operator);
        ArrayList<Expression> dependencies = new ArrayList<Expression>(2);
        dependencies.add(leftOperand);
        dependencies.add(rightOperand);
        this.setDependencies(dependencies);
        return this.done();
    }

    public Expression createLogicalComplementExpression(String name, Expression expression) throws InvalidExpressionException {
        this.createNewInstance(name).setExpressionType(ExpressionType.TYPE_CONDITION.name()).setReturnType(Boolean.class.getName()).setContent(NOT_COMPARATOR);
        this.setDependencies(Collections.singletonList(expression));
        return this.done();
    }

    public Expression createXPathExpressionWithDataAsContent(String name, String xPathExpression, XPathReturnType returnType, String xmlContentAsDataRef) throws InvalidExpressionException {
        ExpressionBuilder expBuilder = this.createNewInstance(name).setExpressionType(ExpressionType.TYPE_XPATH_READ).setContent(xPathExpression);
        this.getXPathReturnType(returnType, expBuilder);
        Expression dep = new ExpressionBuilder().createNewInstance("xmlContent").setContent(xmlContentAsDataRef).setExpressionType(ExpressionType.TYPE_VARIABLE).setReturnType(String.class.getName()).done();
        expBuilder.setDependencies(Arrays.asList(dep));
        return expBuilder.done();
    }

    public Expression createXPathExpression(String name, String xPathExpression, XPathReturnType returnType, String xmlContent) throws InvalidExpressionException {
        ExpressionBuilder expBuilder = this.createNewInstance(name).setExpressionType(ExpressionType.TYPE_XPATH_READ).setContent(xPathExpression);
        this.getXPathReturnType(returnType, expBuilder);
        Expression dep = new ExpressionBuilder().createNewInstance("xmlContent").setContent(xmlContent).setExpressionType(ExpressionType.TYPE_CONSTANT).setReturnType(String.class.getName()).done();
        expBuilder.setDependencies(Arrays.asList(dep));
        return expBuilder.done();
    }

    protected void getXPathReturnType(XPathReturnType returnType, ExpressionBuilder expBuilder) {
        switch (returnType) {
            case BOOLEAN: {
                expBuilder.setReturnType(Boolean.class.getName());
                break;
            }
            case DOUBLE: {
                expBuilder.setReturnType(Double.class.getName());
                break;
            }
            case NODE: {
                expBuilder.setReturnType(Node.class.getName());
                break;
            }
            case NODE_LIST: {
                expBuilder.setReturnType(NodeList.class.getName());
                break;
            }
            case STRING: {
                expBuilder.setReturnType(String.class.getName());
                break;
            }
            case FLOAT: {
                expBuilder.setReturnType(Float.class.getName());
                break;
            }
            case INTEGER: {
                expBuilder.setReturnType(Integer.class.getName());
                break;
            }
            case LONG: {
                expBuilder.setReturnType(Long.class.getName());
                break;
            }
        }
    }

    public Expression createJavaMethodCallExpression(String name, String methodName, String returnType, Expression entityExpression) throws InvalidExpressionException {
        this.createNewInstance(name).setExpressionType(ExpressionType.TYPE_JAVA_METHOD_CALL.name()).setReturnType(returnType).setContent(methodName);
        this.setDependencies(Collections.singletonList(entityExpression));
        return this.done();
    }

    static {
        validOperators.add(LESS_THAN_COMPARATOR);
        validOperators.add(GREATER_THAN_COMPARATOR);
        validOperators.add(LESS_THAN_OR_EQUALS_COMPARATOR);
        validOperators.add(GREATER_THAN_OR_EQUALS_COMPARATOR);
        validOperators.add(EQUALS_COMPARATOR);
        validOperators.add(NOT_EQUALS_COMPARATOR);
        validOperators.add(NOT_COMPARATOR);
        numericTypes = new HashSet();
        numericTypes.add(Integer.class.getName());
        numericTypes.add(Long.class.getName());
        numericTypes.add(Double.class.getName());
        numericTypes.add(Float.class.getName());
        numericTypes.add(Short.class.getName());
        numericTypes.add(Byte.class.getName());
        numericTypes.add(Integer.TYPE.getName());
        numericTypes.add(Long.TYPE.getName());
        numericTypes.add(Double.TYPE.getName());
        numericTypes.add(Float.TYPE.getName());
        numericTypes.add(Short.TYPE.getName());
        numericTypes.add(Byte.TYPE.getName());
    }
}

