/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class IOUtil {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int BUFF_SIZE = 100000;
    public static final String fEncoding = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, byte[] fileContent) throws IOException {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        FileOutputStream os = null;
        os = new FileOutputStream(file);
        try {
            ((OutputStream)os).write(fileContent);
            os.flush();
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public static byte[] generateJar(Class<?> ... classes) throws IOException {
        return IOUtil.generateJar(IOUtil.getResources(classes));
    }

    public static Map<String, byte[]> getResources(Class<?> ... classes) throws IOException {
        if (classes == null || classes.length == 0) {
            String message = "No classes available";
            throw new IOException("No classes available");
        }
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        for (Class<?> clazz : classes) {
            resources.put(clazz.getName().replace(".", "/") + ".class", IOUtil.getClassData(clazz));
            for (Class<?> internalClass : clazz.getDeclaredClasses()) {
                resources.put(internalClass.getName().replace(".", "/") + ".class", IOUtil.getClassData(internalClass));
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getClassData(Class<?> clazz) throws IOException {
        if (clazz == null) {
            String message = "Class is null";
            throw new IOException("Class is null");
        }
        String resource = clazz.getName().replace('.', '/') + ".class";
        InputStream inputStream = clazz.getClassLoader().getResourceAsStream(resource);
        byte[] data = null;
        try {
            if (inputStream == null) {
                throw new IOException("Impossible to get stream from class: " + clazz.getName() + ", className= " + resource);
            }
            data = IOUtil.getAllContentFrom(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateJar(Map<String, byte[]> resources) throws IOException {
        if (resources == null || resources.size() == 0) {
            String message = "No resources available";
            throw new IOException("No resources available");
        }
        ByteArrayOutputStream baos = null;
        ZipOutputStream jarOutStream = null;
        try {
            baos = new ByteArrayOutputStream();
            jarOutStream = new JarOutputStream(new BufferedOutputStream(baos));
            for (Map.Entry<String, byte[]> resource : resources.entrySet()) {
                ((JarOutputStream)jarOutStream).putNextEntry(new JarEntry(resource.getKey()));
                jarOutStream.write(resource.getValue());
            }
            jarOutStream.flush();
            baos.flush();
        }
        finally {
            if (jarOutStream != null) {
                jarOutStream.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAllContentFrom(InputStream in) throws IOException {
        byte[] resultArray;
        if (in == null) {
            throw new IOException("The InputStream is null!");
        }
        byte[] buffer = new byte[100000];
        BufferedInputStream bis = null;
        ByteArrayOutputStream result = null;
        try {
            int amountRead;
            bis = new BufferedInputStream(in);
            result = new ByteArrayOutputStream();
            while ((amountRead = bis.read(buffer)) > 0) {
                result.write(buffer, 0, amountRead);
            }
            resultArray = result.toByteArray();
            result.flush();
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (result != null) {
                result.close();
            }
        }
        return resultArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAllContentFrom(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] byArray = IOUtil.getAllContentFrom(in);
            return byArray;
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAllContentFrom(URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            byte[] byArray = IOUtil.getAllContentFrom(in);
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static boolean deleteDir(File dir) throws IOException {
        return IOUtil.deleteDir(dir, 1, 0L);
    }

    public static boolean deleteDir(File dir, int attempts, long sleepTime) throws IOException {
        boolean result = true;
        if (!dir.exists()) {
            return false;
        }
        if (!dir.isDirectory()) {
            throw new IOException("Unable to delete directory: " + dir + ", it is not a directory");
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                IOUtil.deleteDir(files[i], attempts, sleepTime);
                continue;
            }
            result = result && IOUtil.deleteFile(files[i], attempts, sleepTime);
        }
        result = result && IOUtil.deleteFile(dir, attempts, sleepTime);
        return result;
    }

    public static boolean deleteFile(File f, int attempts, long sleepTime) {
        int retries = attempts;
        while (retries > 0 && !f.delete()) {
            --retries;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {}
        }
        return retries > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zip(Map<String, byte[]> files) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        try {
            for (Map.Entry<String, byte[]> file : files.entrySet()) {
                zos.putNextEntry(new ZipEntry(file.getKey()));
                zos.write(file.getValue());
                zos.closeEntry();
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            zos.close();
        }
    }

    public static void zipDir(String dir2zip, ZipOutputStream zos, String root) throws IOException {
        File zipDir = new File(dir2zip);
        String[] dirList = zipDir.list();
        byte[] readBuffer = new byte[100000];
        int bytesIn = 0;
        for (int i = 0; i < dirList.length; ++i) {
            File f = new File(zipDir, dirList[i]);
            String path = f.getPath();
            if (f.isDirectory()) {
                String filePath = path;
                IOUtil.zipDir(filePath, zos, root);
                continue;
            }
            FileInputStream fis = new FileInputStream(f);
            ZipEntry anEntry = new ZipEntry(path.substring(root.length() + 1, path.length()).replace(String.valueOf(File.separatorChar), "/"));
            zos.putNextEntry(anEntry);
            while ((bytesIn = fis.read(readBuffer)) != -1) {
                zos.write(readBuffer, 0, bytesIn);
            }
            fis.close();
            zos.flush();
            zos.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, String content) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), fEncoding);
        try {
            out.write(content);
        }
        finally {
            ((Writer)out).close();
        }
    }

    public static String read(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream, fEncoding);
        return IOUtil.read(scanner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String read(Scanner scanner) {
        StringBuilder text = new StringBuilder();
        try {
            boolean isFirst = true;
            while (scanner.hasNextLine()) {
                if (isFirst) {
                    text.append(scanner.nextLine());
                } else {
                    text.append(LINE_SEPARATOR + scanner.nextLine());
                }
                isFirst = false;
            }
        }
        finally {
            scanner.close();
        }
        return text.toString();
    }

    public static String read(File file) throws IOException {
        Scanner scanner = new Scanner((InputStream)new FileInputStream(file), fEncoding);
        return IOUtil.read(scanner);
    }

    public static void unzipToFolder(InputStream inputStream, File folder) throws IOException, FileNotFoundException {
        ZipInputStream zipInputstream = new ZipInputStream(inputStream);
        ZipEntry zipentry = zipInputstream.getNextEntry();
        byte[] buf = new byte[100000];
        while (zipentry != null) {
            int n;
            String entryName = zipentry.getName();
            entryName = entryName.replace('/', File.separatorChar);
            entryName = entryName.replace('\\', File.separatorChar);
            entryName = folder.getAbsolutePath() + File.separatorChar + entryName;
            File newFile = new File(entryName);
            if (zipentry.isDirectory()) {
                if (!newFile.mkdirs()) break;
                zipentry = zipInputstream.getNextEntry();
                continue;
            }
            newFile.getParentFile().mkdirs();
            FileOutputStream fileoutputstream = new FileOutputStream(newFile);
            while ((n = zipInputstream.read(buf, 0, 100000)) > -1) {
                fileoutputstream.write(buf, 0, n);
            }
            fileoutputstream.close();
            zipInputstream.closeEntry();
            zipentry = zipInputstream.getNextEntry();
        }
        zipInputstream.close();
    }
}

