/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.io.xml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.xml.bind.ValidationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.bonitasoft.engine.io.xml.BindingHandler;
import org.bonitasoft.engine.io.xml.ElementBinding;
import org.bonitasoft.engine.io.xml.InvalidSchemaException;
import org.bonitasoft.engine.io.xml.XMLNode;
import org.bonitasoft.engine.io.xml.XMLParseException;
import org.bonitasoft.engine.io.xml.XMLParserErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLHandler {
    private static final String ENCODING = "UTF-8";
    private final List<Class<? extends ElementBinding>> bindings;
    private final SchemaFactory factory;
    private Schema schema;
    private final DocumentBuilder documentBuilder;
    private final Transformer transformer;

    public XMLHandler(List<Class<? extends ElementBinding>> bindings) throws ParserConfigurationException, TransformerConfigurationException {
        this.bindings = bindings;
        this.factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        this.transformer = transformerFactory.newTransformer();
        this.transformer.setOutputProperty("indent", "yes");
        this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        this.transformer.setOutputProperty("encoding", ENCODING);
    }

    private Node addNode(Document document, Node parentNode, XMLNode node) {
        String name = node.getName();
        Map<String, String> attributes = node.getAttributes();
        String content = node.getContent();
        Element element = document.createElement(name);
        if (content != null) {
            element.setTextContent(content);
        }
        if (attributes != null) {
            for (Map.Entry entry : attributes.entrySet()) {
                String attributeName = (String)entry.getKey();
                String attributeValue = (String)entry.getValue();
                if (attributeValue == null) continue;
                element.setAttribute(attributeName, attributeValue);
            }
        }
        for (XMLNode xMLNode : node.getChildNodes()) {
            Node child = this.addNode(document, element, xMLNode);
            element.appendChild(child);
        }
        if (parentNode == null) {
            return element;
        }
        return parentNode.appendChild(element);
    }

    private Document getDocument(XMLNode rootNode) {
        Document document = this.documentBuilder.newDocument();
        document.setXmlVersion("1.0");
        document.setXmlStandalone(true);
        Node root = this.addNode(document, null, rootNode);
        document.appendChild(root);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectFromXML(File file) throws XMLParseException, FileNotFoundException, IOException {
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), ENCODING);
        Object objectFromXML = null;
        try {
            objectFromXML = this.getObjectFromXML(isr);
        }
        finally {
            isr.close();
        }
        return objectFromXML;
    }

    public Object getObjectFromXML(Reader xmlReader) throws IOException, XMLParseException {
        BindingHandler handler = new BindingHandler(this.bindings);
        XMLParserErrorHandler errorhandler = new XMLParserErrorHandler();
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(handler);
            reader.setErrorHandler(errorhandler);
            InputSource xmlInputSource = new InputSource(xmlReader);
            reader.parse(xmlInputSource);
            return handler.getModel();
        }
        catch (SAXException e) {
            throw new XMLParseException(e);
        }
    }

    public void setSchema(InputStream schemaStream) throws InvalidSchemaException {
        try {
            this.schema = this.factory.newSchema(new StreamSource(schemaStream));
        }
        catch (SAXException e) {
            throw new InvalidSchemaException(e);
        }
    }

    public void validate(File file) throws ValidationException, IOException {
        this.validate(new StreamSource(file));
    }

    private void validate(StreamSource source) throws ValidationException, IOException {
        try {
            if (this.schema == null) {
                throw new ValidationException("No schema defined");
            }
            Validator validator = this.schema.newValidator();
            validator.validate(source);
        }
        catch (SAXException e) {
            throw new ValidationException((Throwable)e);
        }
    }

    public void validate(Reader content) throws ValidationException, IOException {
        this.validate(new StreamSource(content));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] write(XMLNode rootNode) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] xmlContent = null;
        try {
            this.write(rootNode, outputStream);
            xmlContent = outputStream.toByteArray();
        }
        catch (IOException e) {
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {}
        }
        return xmlContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(XMLNode rootNode, OutputStream outputStream) throws IOException {
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(outputStream, ENCODING);
            this.write(rootNode, osw);
        }
        finally {
            if (osw != null) {
                osw.close();
            }
        }
    }

    private void write(XMLNode rootNode, StreamResult result) throws TransformerException {
        Document document = this.getDocument(rootNode);
        DOMSource source = new DOMSource(document);
        this.transformer.transform(source, result);
    }

    public void write(XMLNode rootNode, Writer writer) throws IOException {
        try {
            StreamResult sr = new StreamResult(writer);
            this.write(rootNode, sr);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

