/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.search;

import java.io.Serializable;
import java.util.List;
import org.bonitasoft.engine.search.Order;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.Sort;
import org.bonitasoft.engine.search.impl.SearchFilter;
import org.bonitasoft.engine.search.impl.SearchOptionsImpl;

public class SearchOptionsBuilder {
    private final SearchOptionsImpl options;

    public SearchOptionsBuilder(int startIndex, int maxResults) {
        this.options = new SearchOptionsImpl(startIndex, maxResults);
    }

    public SearchOptionsBuilder(SearchOptions searchOptions) {
        this.options = new SearchOptionsImpl(searchOptions.getStartIndex(), searchOptions.getMaxResults());
        this.options.setFilters(searchOptions.getFilters());
        this.options.setSorts(searchOptions.getSorts());
        this.options.setSearchTerm(searchOptions.getSearchTerm());
    }

    public SearchOptionsBuilder filter(String field, Serializable value) {
        this.options.addFilter(field, value);
        return this;
    }

    public SearchOptionsBuilder greaterThan(String field, Serializable value) {
        this.options.addGreaterThanFilter(field, value);
        return this;
    }

    public SearchOptionsBuilder greaterOrEquals(String field, Serializable value) {
        this.options.addGreaterOrEqualsFilter(field, value);
        return this;
    }

    public SearchOptionsBuilder lessThan(String field, Serializable value) {
        this.options.addLessThanFilter(field, value);
        return this;
    }

    public SearchOptionsBuilder lessOrEquals(String field, Serializable value) {
        this.options.addLessOrEqualsFilter(field, value);
        return this;
    }

    public SearchOptionsBuilder between(String field, Serializable from, Serializable to) {
        this.options.addBetweenFilter(field, from, to);
        return this;
    }

    public SearchOptionsBuilder differentFrom(String field, Serializable value) {
        this.options.addDifferentFromFilter(field, value);
        return this;
    }

    public SearchOptionsBuilder or() {
        if (this.options.getFilters().size() == 0) {
            throw new IllegalArgumentException("OR operator cannot be the first filter in the list.");
        }
        this.options.addOrFilter();
        return this;
    }

    public SearchOptionsBuilder and() {
        if (this.options.getFilters().size() == 0) {
            throw new IllegalArgumentException("AND operator cannot be the first filter in the list.");
        }
        this.options.addAndFilter();
        return this;
    }

    public SearchOptionsBuilder searchTerm(String value) {
        this.options.setSearchTerm(value);
        return this;
    }

    public SearchOptionsBuilder sort(String field, Order order) {
        this.options.addSort(field, order);
        return this;
    }

    public SearchOptionsBuilder setFilters(List<SearchFilter> filters) {
        this.options.setFilters(filters);
        return this;
    }

    public SearchOptionsBuilder setSort(List<Sort> sorts) {
        this.options.setSorts(sorts);
        return this;
    }

    public SearchOptions done() {
        return this.options;
    }
}

