/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm;

import java.util.Arrays;
import java.util.List;
import org.bonitasoft.engine.bdm.AbstractQueryGenerator;
import org.bonitasoft.engine.bdm.BDMSimpleNameProvider;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.Query;
import org.bonitasoft.engine.bdm.model.UniqueConstraint;
import org.bonitasoft.engine.bdm.model.field.FieldType;
import org.bonitasoft.engine.bdm.model.field.SimpleField;

public class FindQueryGenerator
extends AbstractQueryGenerator {
    @Override
    public String getQueryPrefix() {
        return "find";
    }

    @Override
    protected void addOrderBy(char tablePrefix, StringBuilder builder) {
        builder.append("ORDER BY ").append(tablePrefix).append('.').append("persistenceId");
    }

    @Override
    public void buildSelect(char simpleNameAlias, StringBuilder builder) {
        builder.append("SELECT ").append(simpleNameAlias).append("\n");
    }

    @Override
    public String getListReturnType() {
        return List.class.getName();
    }

    @Override
    public Query createQueryForPersistenceId(BusinessObject businessObject) {
        SimpleField persistenceIdField = new SimpleField();
        persistenceIdField.setName("persistenceId");
        persistenceIdField.setType(FieldType.LONG);
        String name = this.createQueryNameForField(persistenceIdField);
        UniqueConstraint constraint = new UniqueConstraint();
        constraint.setFieldNames(Arrays.asList(persistenceIdField.getName()));
        String content = this.createQueryContentForUniqueConstraint(businessObject.getQualifiedName(), constraint);
        Query q = new Query(name, content, businessObject.getQualifiedName());
        q.addQueryParameter(persistenceIdField.getName(), persistenceIdField.getType().getClazz().getName());
        return q;
    }

    @Override
    protected String getQualifiedReturnType(BusinessObject businessObject) {
        return businessObject.getQualifiedName();
    }

    @Override
    protected String getQueryContentForLazyField() {
        return "SELECT %s FROM %s %s JOIN %s.%s as %s WHERE %s.%s= :%s";
    }

    protected String createQueryContentForUniqueConstraint(String businessObjectName, UniqueConstraint uniqueConstraint) {
        this.checkArgumentisNotEmpty(businessObjectName);
        String simpleName = BDMSimpleNameProvider.getSimpleBusinessObjectName(businessObjectName);
        char alias = BDMSimpleNameProvider.getSimpleNameAlias(simpleName);
        String selectBlock = this.buildSelectFrom(simpleName, alias);
        return this.buildQueryForUniqueConstraint(uniqueConstraint, alias, selectBlock);
    }

    protected String buildQueryForUniqueConstraint(UniqueConstraint uniqueConstraint, char alias, String selectBlock) {
        StringBuilder builder = new StringBuilder();
        builder.append(selectBlock);
        builder.append(this.buildWhereAnd(alias, uniqueConstraint.getFieldNames()));
        return builder.toString();
    }

    private String buildWhereAnd(char prefix, List<String> parameterNames) {
        String paramName;
        StringBuilder builder = new StringBuilder("WHERE ");
        int numberOfParameters = parameterNames.size() - 1;
        for (int i = 0; i < numberOfParameters; ++i) {
            paramName = parameterNames.get(i);
            builder.append(this.buildCompareField(prefix, paramName));
            builder.append("AND ");
        }
        paramName = parameterNames.get(numberOfParameters);
        builder.append(this.buildCompareField(prefix, paramName));
        return builder.toString();
    }
}

