/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.process.impl;

import org.bonitasoft.engine.bpm.flownode.impl.internal.FlowElementContainerDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.HumanTaskDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.ManualTaskDefinitionImpl;
import org.bonitasoft.engine.bpm.process.impl.ActivityDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.ProcessDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.UserFilterDefinitionBuilder;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.ExpressionBuilder;
import org.bonitasoft.engine.expression.InvalidExpressionException;

public class ManualTaskDefinitionBuilder
extends ActivityDefinitionBuilder {
    public ManualTaskDefinitionBuilder(ProcessDefinitionBuilder processDefinitionBuilder, FlowElementContainerDefinitionImpl container, String name, String actorName) {
        super(container, processDefinitionBuilder, ManualTaskDefinitionBuilder.getManualTask(name, actorName));
    }

    private static ManualTaskDefinitionImpl getManualTask(String name, String actorName) {
        return new ManualTaskDefinitionImpl(name, actorName);
    }

    public UserFilterDefinitionBuilder addUserFilter(String name, String userFilterId, String version) {
        return new UserFilterDefinitionBuilder(this.getProcessBuilder(), this.getContainer(), name, userFilterId, version, (HumanTaskDefinitionImpl)this.getActivity());
    }

    public ManualTaskDefinitionBuilder addExpectedDuration(long time) {
        try {
            Expression expression = new ExpressionBuilder().createConstantLongExpression(time);
            return this.addExpectedDuration(expression);
        }
        catch (InvalidExpressionException e) {
            throw new BonitaRuntimeException(e);
        }
    }

    public ManualTaskDefinitionBuilder addExpectedDuration(Expression expression) {
        ((ManualTaskDefinitionImpl)this.getActivity()).setExpectedDuration(expression.copy());
        return this;
    }

    public ManualTaskDefinitionBuilder addPriority(String priority) {
        ((ManualTaskDefinitionImpl)this.getActivity()).setPriority(priority);
        return this;
    }
}

