/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.process.impl.internal;

import java.util.List;
import org.bonitasoft.engine.bpm.businessdata.BusinessDataDefinition;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.context.ContextEntry;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.document.DocumentDefinition;
import org.bonitasoft.engine.bpm.document.DocumentListDefinition;
import org.bonitasoft.engine.bpm.flownode.ActivityDefinition;
import org.bonitasoft.engine.bpm.flownode.BoundaryEventDefinition;
import org.bonitasoft.engine.bpm.flownode.CallActivityDefinition;
import org.bonitasoft.engine.bpm.flownode.CatchEventDefinition;
import org.bonitasoft.engine.bpm.flownode.CatchMessageEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.CorrelationDefinition;
import org.bonitasoft.engine.bpm.flownode.EndEventDefinition;
import org.bonitasoft.engine.bpm.flownode.EventDefinition;
import org.bonitasoft.engine.bpm.flownode.EventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.FlowElementContainerDefinition;
import org.bonitasoft.engine.bpm.flownode.FlowNodeDefinition;
import org.bonitasoft.engine.bpm.flownode.GatewayDefinition;
import org.bonitasoft.engine.bpm.flownode.HumanTaskDefinition;
import org.bonitasoft.engine.bpm.flownode.IntermediateCatchEventDefinition;
import org.bonitasoft.engine.bpm.flownode.IntermediateThrowEventDefinition;
import org.bonitasoft.engine.bpm.flownode.MessageEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.MultiInstanceLoopCharacteristics;
import org.bonitasoft.engine.bpm.flownode.ReceiveTaskDefinition;
import org.bonitasoft.engine.bpm.flownode.SendTaskDefinition;
import org.bonitasoft.engine.bpm.flownode.StandardLoopCharacteristics;
import org.bonitasoft.engine.bpm.flownode.StartEventDefinition;
import org.bonitasoft.engine.bpm.flownode.ThrowEventDefinition;
import org.bonitasoft.engine.bpm.flownode.ThrowMessageEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.TimerEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.TransitionDefinition;
import org.bonitasoft.engine.bpm.flownode.UserTaskDefinition;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;
import org.bonitasoft.engine.bpm.process.ModelFinderVisitor;
import org.bonitasoft.engine.bpm.process.SubProcessDefinition;
import org.bonitasoft.engine.bpm.process.Visitable;
import org.bonitasoft.engine.bpm.userfilter.UserFilterDefinition;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.operation.Operation;

public class ExpressionFinder
implements ModelFinderVisitor {
    private Expression toBeFound = null;

    public Expression getFoundExpression() {
        return this.toBeFound;
    }

    @Override
    public void find(Expression expression, long expressionDefinitionId) {
        if (expression.getId() == expressionDefinitionId) {
            this.toBeFound = expression;
        }
    }

    protected void findExpressionFromNotNullContainer(Visitable visitable, long expressionDefinitionId) {
        if (visitable != null && this.toBeFound == null) {
            visitable.accept(this, expressionDefinitionId);
        }
    }

    protected void getExpressionFromOperationList(List<Operation> operations, long expressionDefinitionId) {
        for (Operation operation : operations) {
            this.findExpressionFromNotNullContainer(operation, expressionDefinitionId);
        }
    }

    @Override
    public void find(DesignProcessDefinition designProcessDefinition, long expressionDefinitionId) {
        List<Expression> expressions = designProcessDefinition.getStringIndexValues();
        for (Expression expression : expressions) {
            this.findExpressionFromNotNullContainer(expression, expressionDefinitionId);
        }
        for (ContextEntry contextEntry : designProcessDefinition.getContext()) {
            this.findExpressionFromNotNullContainer(contextEntry, expressionDefinitionId);
        }
        this.findExpressionFromNotNullContainer(designProcessDefinition.getFlowElementContainer(), expressionDefinitionId);
    }

    @Override
    public void find(FlowNodeDefinition flowNodeDefinition, long expressionDefinitionId) {
        if (flowNodeDefinition != null) {
            this.findExpressionFromNotNullContainer(flowNodeDefinition.getDisplayName(), expressionDefinitionId);
            this.findExpressionFromNotNullContainer(flowNodeDefinition.getDisplayDescription(), expressionDefinitionId);
            this.findExpressionFromNotNullContainer(flowNodeDefinition.getDisplayDescriptionAfterCompletion(), expressionDefinitionId);
            this.findExpressionFromNotNullContainer(flowNodeDefinition.getDefaultTransition(), expressionDefinitionId);
            for (TransitionDefinition transitionDefinition : flowNodeDefinition.getIncomingTransitions()) {
                this.findExpressionFromNotNullContainer(transitionDefinition, expressionDefinitionId);
            }
            for (TransitionDefinition transitionDefinition : flowNodeDefinition.getOutgoingTransitions()) {
                this.findExpressionFromNotNullContainer(transitionDefinition, expressionDefinitionId);
            }
            for (ConnectorDefinition connectorDefinition : flowNodeDefinition.getConnectors()) {
                this.findExpressionFromNotNullContainer(connectorDefinition, expressionDefinitionId);
            }
        }
    }

    @Override
    public void find(FlowElementContainerDefinition container, long expressionDefinitionId) {
        for (ActivityDefinition activity : container.getActivities()) {
            this.findExpressionFromNotNullContainer(activity, expressionDefinitionId);
        }
        for (TransitionDefinition transition : container.getTransitions()) {
            this.findExpressionFromNotNullContainer(transition, expressionDefinitionId);
        }
        for (GatewayDefinition gatewayDefinition : container.getGatewaysList()) {
            this.findExpressionFromNotNullContainer(gatewayDefinition, expressionDefinitionId);
        }
        for (StartEventDefinition startEventDefinition : container.getStartEvents()) {
            this.findExpressionFromNotNullContainer(startEventDefinition, expressionDefinitionId);
        }
        for (EndEventDefinition endEventDefinition : container.getEndEvents()) {
            this.findExpressionFromNotNullContainer(endEventDefinition, expressionDefinitionId);
        }
        for (IntermediateCatchEventDefinition catchEventDefinition : container.getIntermediateCatchEvents()) {
            this.findExpressionFromNotNullContainer(catchEventDefinition, expressionDefinitionId);
        }
        for (IntermediateThrowEventDefinition throwEventDefinition : container.getIntermediateThrowEvents()) {
            this.findExpressionFromNotNullContainer(throwEventDefinition, expressionDefinitionId);
        }
        for (DataDefinition dataDefinition : container.getDataDefinitions()) {
            this.findExpressionFromNotNullContainer(dataDefinition, expressionDefinitionId);
        }
        for (DocumentDefinition documentDefinition : container.getDocumentDefinitions()) {
            this.findExpressionFromNotNullContainer(documentDefinition, expressionDefinitionId);
        }
        for (DocumentListDefinition documentListDefinition : container.getDocumentListDefinitions()) {
            this.findExpressionFromNotNullContainer(documentListDefinition, expressionDefinitionId);
        }
        for (BusinessDataDefinition businessDataDefinition : container.getBusinessDataDefinitions()) {
            this.findExpressionFromNotNullContainer(businessDataDefinition, expressionDefinitionId);
        }
        for (ConnectorDefinition connectorDefinition : container.getConnectors()) {
            this.findExpressionFromNotNullContainer(connectorDefinition, expressionDefinitionId);
        }
    }

    @Override
    public void find(ActivityDefinition activityDefinition, long expressionDefinitionId) {
        this.findExpressionFromNotNullContainer(activityDefinition.getDisplayName(), expressionDefinitionId);
        this.findExpressionFromNotNullContainer(activityDefinition.getLoopCharacteristics(), expressionDefinitionId);
        for (BusinessDataDefinition businessDataDefinition : activityDefinition.getBusinessDataDefinitions()) {
            this.findExpressionFromNotNullContainer(businessDataDefinition, expressionDefinitionId);
        }
        for (DataDefinition dataDefinition : activityDefinition.getDataDefinitions()) {
            this.findExpressionFromNotNullContainer(dataDefinition, expressionDefinitionId);
        }
        this.getExpressionFromOperationList(activityDefinition.getOperations(), expressionDefinitionId);
        for (BoundaryEventDefinition boundaryEventDefinition : activityDefinition.getBoundaryEventDefinitions()) {
            this.findExpressionFromNotNullContainer(boundaryEventDefinition, expressionDefinitionId);
        }
    }

    @Override
    public void find(HumanTaskDefinition humanTaskDefinition, long expressionDefinitionId) {
        if (humanTaskDefinition != null) {
            this.findExpressionFromNotNullContainer(humanTaskDefinition.getUserFilter(), expressionDefinitionId);
        }
        this.findExpressionFromNotNullContainer(humanTaskDefinition.getExpectedDuration(), expressionDefinitionId);
    }

    @Override
    public void find(UserFilterDefinition userFilterDefinition, long expressionDefinitionId) {
        for (Expression expression : userFilterDefinition.getInputs().values()) {
            this.findExpressionFromNotNullContainer(expression, expressionDefinitionId);
        }
    }

    @Override
    public void find(UserTaskDefinition userTaskDefinition, long expressionDefinitionId) {
        for (ContextEntry contextEntry : userTaskDefinition.getContext()) {
            this.findExpressionFromNotNullContainer(contextEntry, expressionDefinitionId);
        }
    }

    @Override
    public void find(SendTaskDefinition sendTaskDefinition, long expressionDefinitionId) {
        this.findExpressionFromNotNullContainer(sendTaskDefinition.getMessageTrigger(), expressionDefinitionId);
    }

    @Override
    public void find(ReceiveTaskDefinition receiveTaskDefinition, long expressionDefinitionId) {
        this.findExpressionFromNotNullContainer(receiveTaskDefinition.getTrigger(), expressionDefinitionId);
    }

    @Override
    public void find(SubProcessDefinition subProcessDefinition, long expressionDefinitionId) {
        this.findExpressionFromNotNullContainer(subProcessDefinition.getSubProcessContainer(), expressionDefinitionId);
    }

    @Override
    public void find(CallActivityDefinition callActivityDefinition, long expressionDefinitionId) {
        this.findExpressionFromNotNullContainer(callActivityDefinition.getCallableElement(), expressionDefinitionId);
        this.findExpressionFromNotNullContainer(callActivityDefinition.getCallableElementVersion(), expressionDefinitionId);
        for (Expression expression : callActivityDefinition.getProcessStartContractInputs().values()) {
            this.findExpressionFromNotNullContainer(expression, expressionDefinitionId);
        }
        this.getExpressionFromOperationList(callActivityDefinition.getDataInputOperations(), expressionDefinitionId);
        this.getExpressionFromOperationList(callActivityDefinition.getDataOutputOperations(), expressionDefinitionId);
    }

    @Override
    public void find(Operation operation, long expressionDefinitionId) {
        this.findExpressionFromNotNullContainer(operation.getRightOperand(), expressionDefinitionId);
    }

    @Override
    public void find(TransitionDefinition transition, long expressionDefinitionId) {
        this.findExpressionFromNotNullContainer(transition.getCondition(), expressionDefinitionId);
    }

    @Override
    public void find(BusinessDataDefinition businessDataDefinition, long expressionDefinitionId) {
        this.findExpressionFromNotNullContainer(businessDataDefinition.getDefaultValueExpression(), expressionDefinitionId);
    }

    @Override
    public void find(DataDefinition dataDefinition, long expressionDefinitionId) {
        this.findExpressionFromNotNullContainer(dataDefinition.getDefaultValueExpression(), expressionDefinitionId);
    }

    @Override
    public void find(CorrelationDefinition correlationDefinition, long expressionDefinitionId) {
        this.findExpressionFromNotNullContainer(correlationDefinition.getKey(), expressionDefinitionId);
        this.findExpressionFromNotNullContainer(correlationDefinition.getValue(), expressionDefinitionId);
    }

    @Override
    public void find(CatchMessageEventTriggerDefinition catchMessageEventTriggerDefinition, long expressionDefinitionId) {
        this.getExpressionFromOperationList(catchMessageEventTriggerDefinition.getOperations(), expressionDefinitionId);
    }

    @Override
    public void find(ThrowMessageEventTriggerDefinition throwMessageEventTriggerDefinition, long expressionDefinitionId) {
        this.findExpressionFromNotNullContainer(throwMessageEventTriggerDefinition.getTargetFlowNode(), expressionDefinitionId);
        this.findExpressionFromNotNullContainer(throwMessageEventTriggerDefinition.getTargetProcess(), expressionDefinitionId);
        for (DataDefinition dataDefinition : throwMessageEventTriggerDefinition.getDataDefinitions()) {
            this.findExpressionFromNotNullContainer(dataDefinition, expressionDefinitionId);
        }
    }

    @Override
    public void find(MessageEventTriggerDefinition messageEventTriggerDefinition, long expressionDefinitionId) {
        for (CorrelationDefinition correlationDefinition : messageEventTriggerDefinition.getCorrelations()) {
            this.findExpressionFromNotNullContainer(correlationDefinition, expressionDefinitionId);
        }
    }

    @Override
    public void find(TimerEventTriggerDefinition timerEventTriggerDefinition, long expressionDefinitionId) {
        this.findExpressionFromNotNullContainer(timerEventTriggerDefinition.getTimerExpression(), expressionDefinitionId);
    }

    @Override
    public void find(ContextEntry contextEntry, long expressionDefinitionId) {
        this.findExpressionFromNotNullContainer(contextEntry.getExpression(), expressionDefinitionId);
    }

    @Override
    public void find(EventDefinition eventDefinition, long expressionDefinitionId) {
        for (EventTriggerDefinition eventTriggerDefinition : eventDefinition.getEventTriggers()) {
            this.findExpressionFromNotNullContainer(eventTriggerDefinition, expressionDefinitionId);
        }
    }

    @Override
    public void find(ThrowEventDefinition throwEventDefinition, long expressionDefinitionId) {
        for (ThrowMessageEventTriggerDefinition throwMessageEventTriggerDefinition : throwEventDefinition.getMessageEventTriggerDefinitions()) {
            this.findExpressionFromNotNullContainer(throwMessageEventTriggerDefinition, expressionDefinitionId);
        }
    }

    @Override
    public void find(CatchEventDefinition catchEventDefinition, long expressionDefinitionId) {
        for (TimerEventTriggerDefinition timerEventTriggerDefinition : catchEventDefinition.getTimerEventTriggerDefinitions()) {
            this.findExpressionFromNotNullContainer(timerEventTriggerDefinition, expressionDefinitionId);
        }
        for (CatchMessageEventTriggerDefinition catchMessageEventTriggerDefinition : catchEventDefinition.getMessageEventTriggerDefinitions()) {
            this.findExpressionFromNotNullContainer(catchMessageEventTriggerDefinition, expressionDefinitionId);
        }
    }

    @Override
    public void find(DocumentDefinition documentDefinition, long expressionDefinitionId) {
        this.findExpressionFromNotNullContainer(documentDefinition.getInitialValue(), expressionDefinitionId);
    }

    @Override
    public void find(DocumentListDefinition documentListDefinition, long expressionDefinitionId) {
        this.findExpressionFromNotNullContainer(documentListDefinition.getExpression(), expressionDefinitionId);
    }

    @Override
    public void find(ConnectorDefinition connectorDefinition, long expressionDefinitionId) {
        for (Expression expression : connectorDefinition.getInputs().values()) {
            this.findExpressionFromNotNullContainer(expression, expressionDefinitionId);
        }
        this.getExpressionFromOperationList(connectorDefinition.getOutputs(), expressionDefinitionId);
    }

    @Override
    public void find(StandardLoopCharacteristics standardLoopCharacteristics, long expressionDefinitionId) {
        this.findExpressionFromNotNullContainer(standardLoopCharacteristics.getLoopCondition(), expressionDefinitionId);
        this.findExpressionFromNotNullContainer(standardLoopCharacteristics.getLoopMax(), expressionDefinitionId);
    }

    @Override
    public void find(MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics, long expressionDefinitionId) {
        this.findExpressionFromNotNullContainer(multiInstanceLoopCharacteristics.getCompletionCondition(), expressionDefinitionId);
        this.findExpressionFromNotNullContainer(multiInstanceLoopCharacteristics.getLoopCardinality(), expressionDefinitionId);
    }
}

