/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bonitasoft.engine.bdm.BDMSimpleNameProvider;
import org.bonitasoft.engine.bdm.model.Index;
import org.bonitasoft.engine.bdm.model.Query;
import org.bonitasoft.engine.bdm.model.UniqueConstraint;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.model.field.RelationField;
import org.bonitasoft.engine.bdm.model.field.SimpleField;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"description", "fields", "uniqueConstraints", "queries", "indexes"})
public class BusinessObject {
    @XmlID
    @XmlAttribute(required=true)
    private String qualifiedName;
    @XmlElement
    private String description;
    @XmlElementWrapper(name="fields", required=true)
    @XmlElements(value={@XmlElement(name="field", type=SimpleField.class, required=true), @XmlElement(name="relationField", type=RelationField.class, required=true)})
    private List<Field> fields = new ArrayList<Field>();
    @XmlElementWrapper(name="uniqueConstraints")
    @XmlElement(name="uniqueConstraint")
    private List<UniqueConstraint> uniqueConstraints = new ArrayList<UniqueConstraint>();
    @XmlElementWrapper(name="indexes")
    @XmlElement(name="index", required=false)
    private List<Index> indexes;
    @XmlElementWrapper(name="queries")
    @XmlElement(name="query")
    private List<Query> queries = new ArrayList<Query>();

    public BusinessObject() {
        this.indexes = new ArrayList<Index>();
    }

    public BusinessObject(String qualifiedName) {
        this();
        this.qualifiedName = qualifiedName;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public void addField(Field field) {
        this.fields.add(field);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.uniqueConstraints.add(uniqueConstraint);
    }

    public UniqueConstraint addUniqueConstraint(String name, String ... fieldNames) {
        if (fieldNames == null || fieldNames.length == 0) {
            throw new IllegalArgumentException("fieldNames cannot be null or empty");
        }
        UniqueConstraint uniqueConstraint = new UniqueConstraint();
        uniqueConstraint.setName(name);
        uniqueConstraint.setFieldNames(Arrays.asList(fieldNames));
        this.addUniqueConstraint(uniqueConstraint);
        return uniqueConstraint;
    }

    public List<UniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public void setUniqueConstraints(List<UniqueConstraint> uniqueConstraints) {
        this.uniqueConstraints = uniqueConstraints;
    }

    public Query addQuery(String name, String queryContent, String returnType) {
        return this.addQuery(name, null, queryContent, returnType);
    }

    public Query addQuery(String name, String description, String queryContent, String returnType) {
        Query query = new Query(name, description, queryContent, returnType);
        this.queries.add(query);
        return query;
    }

    public List<Query> getQueries() {
        return this.queries;
    }

    public void setQueries(List<Query> queries) {
        this.queries = queries;
    }

    public void addIndex(Index index) {
        this.indexes.add(index);
    }

    public Index addIndex(String name, String ... fieldNames) {
        if (fieldNames == null || fieldNames.length == 0) {
            throw new IllegalArgumentException("fieldNames cannot be null or empty");
        }
        Index index = new Index();
        index.setName(name);
        index.setFieldNames(Arrays.asList(fieldNames));
        this.addIndex(index);
        return index;
    }

    public List<Index> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<Index> indexes) {
        this.indexes = indexes;
    }

    public List<BusinessObject> getReferencedBusinessObjectsByComposition() {
        ArrayList<BusinessObject> refs = new ArrayList<BusinessObject>();
        for (Field field : this.fields) {
            if (!this.isACompositionField(field)) continue;
            refs.add(((RelationField)field).getReference());
        }
        return refs;
    }

    private boolean isACompositionField(Field field) {
        return field instanceof RelationField && RelationField.Type.COMPOSITION == ((RelationField)field).getType();
    }

    public boolean isARelationField(String name) {
        boolean relationField = false;
        boolean found = false;
        Iterator<Field> iter = this.fields.iterator();
        while (!found && iter.hasNext()) {
            Field field = iter.next();
            if (!field.getName().equals(name)) continue;
            found = true;
            if (!(field instanceof RelationField)) continue;
            relationField = true;
        }
        return relationField;
    }

    public String getSimpleName() {
        return BDMSimpleNameProvider.getSimpleBusinessObjectName(this.qualifiedName);
    }

    public Field getField(String fieldName) {
        for (Field f : this.getFields()) {
            if (!f.getName().equals(fieldName)) continue;
            return f;
        }
        return null;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.description).append(this.fields).append(this.indexes).append((Object)this.qualifiedName).append(this.queries).append(this.uniqueConstraints).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BusinessObject) {
            BusinessObject other = (BusinessObject)obj;
            return new EqualsBuilder().append((Object)this.description, (Object)other.description).append(this.fields, other.fields).append(this.indexes, other.indexes).append((Object)this.qualifiedName, (Object)other.qualifiedName).append(this.queries, other.queries).append(this.uniqueConstraints, other.uniqueConstraints).isEquals();
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("description", (Object)this.description).append("fields", this.fields).append("indexes", this.indexes).append("qualifiedName", (Object)this.qualifiedName).append("queries", this.queries).append("uniqueConstraints", this.uniqueConstraints).toString();
    }
}

