/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.serialization;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.List;
import org.bonitasoft.engine.bdm.Entity;
import org.bonitasoft.engine.bdm.serialization.CustomLocalDateDeserializer;
import org.bonitasoft.engine.bdm.serialization.CustomLocalDateSerializer;
import org.bonitasoft.engine.bdm.serialization.CustomLocalDateTimeDeserializer;
import org.bonitasoft.engine.bdm.serialization.CustomLocalDateTimeSerializer;
import org.bonitasoft.engine.bdm.serialization.CustomOffsetDateTimeDeserializer;
import org.bonitasoft.engine.bdm.serialization.CustomOffsetDateTimeSerializer;

public class BusinessDataObjectMapper {
    protected ObjectMapper objectMapper = new ObjectMapper();

    public BusinessDataObjectMapper() {
        this.objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        SimpleModule module = new SimpleModule();
        module.addSerializer(LocalDate.class, (JsonSerializer)new CustomLocalDateSerializer());
        module.addSerializer(LocalDateTime.class, (JsonSerializer)new CustomLocalDateTimeSerializer());
        module.addSerializer(OffsetDateTime.class, (JsonSerializer)new CustomOffsetDateTimeSerializer());
        module.addDeserializer(LocalDate.class, (JsonDeserializer)new CustomLocalDateDeserializer());
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)new CustomLocalDateTimeDeserializer());
        module.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new CustomOffsetDateTimeDeserializer());
        this.objectMapper.registerModule((Module)module);
    }

    public void writeValue(StringWriter writer, Entity entity) throws IOException {
        this.objectMapper.writeValue((Writer)writer, (Object)entity);
    }

    public void writeValue(StringWriter writer, List<? extends Entity> entities) throws IOException {
        this.objectMapper.writeValue((Writer)writer, entities);
    }

    public <T extends Serializable> List<T> readListValue(byte[] result, Class<T> loadClass) throws IOException {
        return (List)this.objectMapper.readValue(result, (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, loadClass));
    }

    public <T extends Serializable> T readValue(byte[] result, Class<T> loadClass) throws IOException {
        return (T)((Serializable)this.objectMapper.readValue(result, loadClass));
    }

    public byte[] writeValueAsBytes(Serializable result) throws IOException {
        return this.objectMapper.writeValueAsBytes((Object)result);
    }
}

