/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bonitasoft.engine.api.result.Status;
import org.bonitasoft.engine.api.result.StatusCode;

public class ValidationStatus {
    private final List<Status> statusList = new ArrayList<Status>();

    public void addError(StatusCode code, String error) {
        if (error == null || error.isEmpty()) {
            throw new IllegalArgumentException("error message cannot be null or empty");
        }
        this.statusList.add(Status.errorStatus(code, error));
    }

    public void addError(StatusCode code, String error, Map<String, Serializable> context) {
        if (error == null || error.isEmpty()) {
            throw new IllegalArgumentException("error message cannot be null or empty");
        }
        this.statusList.add(Status.errorStatus(code, error, context));
    }

    public void addWarning(StatusCode code, String warning) {
        if (warning == null || warning.isEmpty()) {
            throw new IllegalArgumentException("warning message cannot be null or empty");
        }
        this.statusList.add(Status.warningStatus(code, warning));
    }

    public void addWarning(StatusCode code, String warning, Map<String, Serializable> context) {
        if (warning == null || warning.isEmpty()) {
            throw new IllegalArgumentException("warning message cannot be null or empty");
        }
        this.statusList.add(Status.warningStatus(code, warning, context));
    }

    public boolean isOk() {
        return this.statusList.stream().map(Status::getLevel).noneMatch(Status.Level.ERROR::equals);
    }

    public void addValidationStatus(ValidationStatus status) {
        this.statusList.addAll(status.getStatuses());
    }

    @Deprecated
    public List<String> getErrors() {
        return this.statusList.stream().filter(status -> Objects.equals((Object)Status.Level.ERROR, (Object)status.getLevel())).map(Status::getMessage).collect(Collectors.toList());
    }

    @Deprecated
    public List<String> getWarnings() {
        return this.statusList.stream().filter(status -> Objects.equals((Object)Status.Level.WARNING, (Object)status.getLevel())).map(Status::getMessage).collect(Collectors.toList());
    }

    public List<Status> getStatuses() {
        return this.statusList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValidationStatus)) {
            return false;
        }
        ValidationStatus that = (ValidationStatus)o;
        return Objects.equals(this.statusList, that.statusList);
    }

    public int hashCode() {
        return Objects.hash(this.statusList);
    }
}

