/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveContribution;
import org.bonitasoft.engine.io.PropertiesManager;

public class ParameterContribution
implements BusinessArchiveContribution {
    static final String PARAMETERS_FILE = "parameters.properties";
    public static final String NULL = "-==NULLL==-";

    @Override
    public boolean readFromBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        File file = new File(barFolder, PARAMETERS_FILE);
        if (!file.exists()) {
            return false;
        }
        Properties properties = PropertiesManager.getProperties(file);
        HashMap<String, String> parameters = new HashMap<String, String>(properties.size());
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            parameters.put((String)property.getKey(), (String)(NULL.equals(property.getValue()) ? null : property.getValue()));
        }
        businessArchive.setParameters(parameters);
        return true;
    }

    @Override
    public void saveToBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        Map<String, String> parameters = businessArchive.getParameters();
        if (parameters != null) {
            Properties properties = new Properties();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                properties.put(entry.getKey(), entry.getValue() == null ? NULL : entry.getValue());
            }
            File file = new File(barFolder, PARAMETERS_FILE);
            PropertiesManager.saveProperties(properties, file);
        }
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public String getName() {
        return "Parameters";
    }
}

