/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.flownode.impl.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.bonitasoft.engine.bpm.flownode.CallActivityDefinition;
import org.bonitasoft.engine.bpm.flownode.CallableElementType;
import org.bonitasoft.engine.bpm.flownode.impl.internal.ActivityDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.NameExpressionMapAdapter;
import org.bonitasoft.engine.bpm.process.ModelFinderVisitor;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.ExpressionBuilder;
import org.bonitasoft.engine.expression.impl.ExpressionImpl;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.operation.OperationBuilder;
import org.bonitasoft.engine.operation.impl.OperationImpl;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class CallActivityDefinitionImpl
extends ActivityDefinitionImpl
implements CallActivityDefinition {
    private static final long serialVersionUID = -6798914951807258918L;
    @XmlElement(type=ExpressionImpl.class)
    private Expression callableElement;
    @XmlElement(type=ExpressionImpl.class)
    private Expression callableElementVersion;
    @XmlElement(type=OperationImpl.class, name="dataInputOperation")
    private final List<Operation> dataInputOperations = new ArrayList<Operation>(3);
    @XmlJavaTypeAdapter(value=NameExpressionMapAdapter.class)
    @XmlElement(name="contractInput")
    private final Map<String, Expression> contractInputs;
    @XmlElement(type=OperationImpl.class, name="dataOutputOperation")
    private final List<Operation> dataOutputOperations = new ArrayList<Operation>(3);
    @XmlAttribute
    private CallableElementType callableElementType;

    public CallActivityDefinitionImpl(String name) {
        super(name);
        this.contractInputs = new HashMap<String, Expression>();
    }

    public CallActivityDefinitionImpl(long id, String name) {
        super(id, name);
        this.contractInputs = new HashMap<String, Expression>();
    }

    public CallActivityDefinitionImpl() {
        this.contractInputs = new HashMap<String, Expression>();
    }

    @Override
    public Expression getCallableElement() {
        return this.callableElement;
    }

    public void setCallableElement(Expression callableElement) {
        this.callableElement = ExpressionBuilder.getNonNullCopy(callableElement);
    }

    @Override
    public Expression getCallableElementVersion() {
        return this.callableElementVersion;
    }

    public void setCallableElementVersion(Expression callableElementVersion) {
        this.callableElementVersion = ExpressionBuilder.getNonNullCopy(callableElementVersion);
    }

    @Override
    public List<Operation> getDataInputOperations() {
        return Collections.unmodifiableList(this.dataInputOperations);
    }

    public void addDataInputOperation(Operation dataInputOperation) {
        this.dataInputOperations.add(OperationBuilder.getNonNullCopy(dataInputOperation));
    }

    @Override
    public List<Operation> getDataOutputOperations() {
        return Collections.unmodifiableList(this.dataOutputOperations);
    }

    public void addDataOutputOperation(Operation dataOutputOperation) {
        this.dataOutputOperations.add(OperationBuilder.getNonNullCopy(dataOutputOperation));
    }

    @Override
    public CallableElementType getCallableElementType() {
        return this.callableElementType;
    }

    public void setCallableElementType(CallableElementType callableElementType) {
        this.callableElementType = callableElementType;
    }

    public void addProcessStartContractInput(String inputName, Expression value) {
        this.contractInputs.put(inputName, ExpressionBuilder.getNonNullCopy(value));
    }

    @Override
    public Map<String, Expression> getProcessStartContractInputs() {
        return this.contractInputs;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("callableElement", (Object)this.callableElement).append("callableElementVersion", (Object)this.callableElementVersion).append("dataInputOperations", this.dataInputOperations).append("contractInputs", this.contractInputs).append("dataOutputOperations", this.dataOutputOperations).append("callableElementType", (Object)this.callableElementType).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CallActivityDefinitionImpl that = (CallActivityDefinitionImpl)o;
        return Objects.equals(this.callableElement, that.callableElement) && Objects.equals(this.callableElementVersion, that.callableElementVersion) && Objects.equals(this.dataInputOperations, that.dataInputOperations) && Objects.equals(this.contractInputs, that.contractInputs) && Objects.equals(this.dataOutputOperations, that.dataOutputOperations) && Objects.equals((Object)this.callableElementType, (Object)that.callableElementType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.callableElement, this.callableElementVersion, this.dataInputOperations, this.contractInputs, this.dataOutputOperations, this.callableElementType});
    }

    @Override
    public void accept(ModelFinderVisitor visitor, long modelId) {
        super.accept(visitor, modelId);
        visitor.find(this, modelId);
    }
}

