/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.page;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PageCreator
implements Serializable {
    private static final long serialVersionUID = 8174091386958635983L;
    private final Map<PageField, Serializable> fields = new HashMap<PageField, Serializable>();

    public PageCreator(String name, String zipName) {
        this.fields.put(PageField.NAME, (Serializable)((Object)name));
        this.fields.put(PageField.CONTENT_NAME, (Serializable)((Object)zipName));
        this.setContentType("page");
    }

    public PageCreator(String name, String zipName, String contentType, Long processDefinitionId) {
        this(name, zipName);
        this.setContentType(contentType);
        this.setProcessDefinitionId(processDefinitionId);
    }

    public String getName() {
        return this.fields.get((Object)PageField.NAME).toString();
    }

    public PageCreator setDescription(String description) {
        this.fields.put(PageField.DESCRIPTION, (Serializable)((Object)description));
        return this;
    }

    public PageCreator setDisplayName(String displayName) {
        this.fields.put(PageField.DISPLAY_NAME, (Serializable)((Object)displayName));
        return this;
    }

    public PageCreator setContentType(String contentType) {
        this.fields.put(PageField.CONTENT_TYPE, (Serializable)((Object)contentType));
        return this;
    }

    public PageCreator setProcessDefinitionId(Long processDefinitionId) {
        this.fields.put(PageField.PROCESS_DEFINITION_ID, processDefinitionId);
        return this;
    }

    public PageCreator setHidden(boolean hidden) {
        this.fields.put(PageField.HIDDEN, Boolean.valueOf(hidden));
        return this;
    }

    public Map<PageField, Serializable> getFields() {
        return this.fields;
    }

    public String toString() {
        return "PageCreator [fields=" + this.fields + "]";
    }

    public static enum PageField {
        NAME,
        DISPLAY_NAME,
        DESCRIPTION,
        CONTENT_NAME,
        CONTENT_TYPE,
        PROCESS_DEFINITION_ID,
        HIDDEN;

    }
}

