/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.result;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bonitasoft.engine.api.result.Status;

public class ExecutionResult
implements Serializable {
    public static final ExecutionResult OK = new ExecutionResult(new Status[0]);
    private List<Status> statuses = new ArrayList<Status>();

    public ExecutionResult(Status ... statuses) {
        this(Arrays.asList(Objects.requireNonNull(statuses)));
    }

    public ExecutionResult(List<Status> statusList) {
        this.statuses.addAll((Collection<Status>)Objects.requireNonNull(statusList));
    }

    public void addStatus(Status ... statuses) {
        this.statuses.addAll(Arrays.asList(Objects.requireNonNull(statuses)));
    }

    public boolean isOk() {
        return this.statuses.isEmpty() || this.statuses.stream().allMatch(status -> status.getLevel() == Status.Level.OK);
    }

    public boolean hasErrors() {
        return this.statuses.stream().anyMatch(status -> status.getLevel() == Status.Level.ERROR);
    }

    public boolean hasWarnings() {
        return this.statuses.stream().anyMatch(status -> status.getLevel() == Status.Level.WARNING);
    }

    public boolean hasInfo() {
        return this.statuses.stream().anyMatch(status -> status.getLevel() == Status.Level.INFO);
    }

    public List<Status> getErrors() {
        return this.statuses.stream().filter(status -> status.getLevel() == Status.Level.ERROR).collect(Collectors.toList());
    }

    public List<Status> getWarnings() {
        return this.statuses.stream().filter(status -> status.getLevel() == Status.Level.WARNING).collect(Collectors.toList());
    }

    public List<Status> getInfo() {
        return this.statuses.stream().filter(status -> status.getLevel() == Status.Level.INFO).collect(Collectors.toList());
    }

    public List<Status> getAllStatus() {
        return Collections.unmodifiableList(this.statuses);
    }
}

