/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import org.bonitasoft.engine.api.result.StatusCode;
import org.bonitasoft.engine.bdm.BDMQueryUtil;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.Query;
import org.bonitasoft.engine.bdm.model.UniqueConstraint;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.validator.SQLNameValidator;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;

public class BusinessObjectValidationRule
extends ValidationRule<BusinessObject, ValidationStatus> {
    private static final String[] RESERVED_PACKAGE_PREFIX = new String[]{"com.bonitasoft.", "org.bonitasoft."};
    private static final int MAX_TABLE_NAME_LENGTH = 30;
    private final SQLNameValidator sqlNameValidator = new SQLNameValidator(30);

    public BusinessObjectValidationRule() {
        super(BusinessObject.class);
    }

    @Override
    public ValidationStatus validate(BusinessObject bo) {
        ValidationStatus status = new ValidationStatus();
        String qualifiedName = bo.getQualifiedName();
        if (qualifiedName == null) {
            status.addError(StatusCode.BUSINESS_OBJECT_WITHOUT_NAME, "A Business Object must have a qualified name");
            return status;
        }
        for (String reservedPrefix : RESERVED_PACKAGE_PREFIX) {
            if (!qualifiedName.startsWith(reservedPrefix)) continue;
            status.addError(StatusCode.RESERVED_PACKAGE_NAME, String.format("Package %s is reserved. Please choose another package name", reservedPrefix), Collections.singletonMap("bdmArtifactName", reservedPrefix));
        }
        String simpleName = bo.getSimpleName();
        if (!SourceVersion.isName(qualifiedName) || !this.sqlNameValidator.isValid(simpleName)) {
            status.addError(StatusCode.INVALID_JAVA_IDENTIFIER_NAME, String.format("%s is not a valid Java qualified name", qualifiedName), Collections.singletonMap("businessObjectName", qualifiedName));
            return status;
        }
        if (simpleName.contains("_")) {
            status.addError(StatusCode.INVALID_CHARACTER_IN_BUSINESS_OBJECT_NAME, "_ is a forbidden character in business object's name");
        }
        if (bo.getFields().isEmpty()) {
            status.addError(StatusCode.BUSINESS_OBJECT_WITHOUT_FIELD, String.format("%s must have at least one field declared", qualifiedName), Collections.singletonMap("businessObjectName", qualifiedName));
        }
        this.validateConstraints(bo, status);
        this.validateQueries(bo, status);
        return status;
    }

    private void validateQueries(BusinessObject bo, ValidationStatus status) {
        Set<String> queryNames = BDMQueryUtil.getAllProvidedQueriesNameForBusinessObject(bo);
        HashMap<String, Serializable> context = new HashMap<String, Serializable>();
        context.put("businessObjectName", (Serializable)((Object)bo.getQualifiedName()));
        for (Query q : bo.getQueries()) {
            if (queryNames.contains(q.getName())) {
                context.put("bdmArtifactName", (Serializable)((Object)q.getName()));
                status.addError(StatusCode.DUPLICATE_QUERY_NAME, "The query named \"" + q.getName() + "\" already exists for " + bo.getQualifiedName(), context);
                continue;
            }
            queryNames.add(q.getName());
        }
    }

    private void validateConstraints(BusinessObject bo, ValidationStatus status) {
        HashSet<String> constraintNames = new HashSet<String>();
        HashMap<String, Serializable> context = new HashMap<String, Serializable>();
        context.put("businessObjectName", (Serializable)((Object)bo.getQualifiedName()));
        for (UniqueConstraint uc : bo.getUniqueConstraints()) {
            List<String> fieldNames;
            String name = uc.getName();
            if (constraintNames.contains(name)) {
                context.put("bdmArtifactName", (Serializable)((Object)name));
                status.addError(StatusCode.DUPLICATE_CONSTRAINT_NAME, "The constraint named \"" + name + "\" already exists for " + bo.getQualifiedName(), context);
            } else {
                constraintNames.add(name);
            }
            if ((fieldNames = uc.getFieldNames()) == null) continue;
            for (String fName : fieldNames) {
                if (this.getField(bo, fName) != null) continue;
                context.put("bdmArtifactName", (Serializable)((Object)fName));
                status.addError(StatusCode.UNKNOWN_FIELD_IN_CONSTRAINT, String.format("The field named %s does not exist in %s", fName, bo.getQualifiedName()), context);
            }
        }
    }

    private Field getField(BusinessObject bo, String name) {
        Field found = null;
        List<Field> fields = bo.getFields();
        for (int index = 0; found == null && index < fields.size(); ++index) {
            Field field = bo.getFields().get(index);
            if (!field.getName().equals(name)) continue;
            found = field;
        }
        return found;
    }
}

