/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule;

import java.util.Collections;
import javax.lang.model.SourceVersion;
import org.bonitasoft.engine.api.result.StatusCode;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.validator.SQLNameValidator;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;

public class FieldValidationRule
extends ValidationRule<Field, ValidationStatus> {
    private static final int MAX_COLUMNAME_LENGTH = 50;
    private final SQLNameValidator sqlNameValidator = new SQLNameValidator(50);

    public FieldValidationRule() {
        super(Field.class);
    }

    @Override
    public ValidationStatus validate(Field field) {
        ValidationStatus status = new ValidationStatus();
        String name = field.getName();
        if (name == null || !SourceVersion.isIdentifier(name) || SourceVersion.isKeyword(name) || this.isForbiddenIdentifier(name)) {
            status.addError(StatusCode.INVALID_FIELD_IDENTIFIER, String.format("%s is not a valid field identifier", name), Collections.singletonMap("bdmArtifactName", name));
            return status;
        }
        return status;
    }

    private boolean isForbiddenIdentifier(String name) {
        return "persistenceId".equalsIgnoreCase(name) || "persistenceVersion".equalsIgnoreCase(name) || !this.sqlNameValidator.isValid(name);
    }
}

