/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.connector.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.bpm.connector.FailAction;
import org.bonitasoft.engine.bpm.flownode.impl.internal.NameExpressionMapAdapter;
import org.bonitasoft.engine.bpm.internal.NamedDefinitionElementImpl;
import org.bonitasoft.engine.bpm.process.ModelFinderVisitor;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.ExpressionBuilder;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.operation.OperationBuilder;
import org.bonitasoft.engine.operation.impl.OperationImpl;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ConnectorDefinitionImpl
extends NamedDefinitionElementImpl
implements ConnectorDefinition {
    private static final long serialVersionUID = 1892648036453422626L;
    @XmlAttribute
    private final String connectorId;
    @XmlJavaTypeAdapter(value=NameExpressionMapAdapter.class)
    private final Map<String, Expression> inputs = new HashMap<String, Expression>();
    @XmlElementWrapper(name="outputs")
    @XmlElement(name="operation", type=OperationImpl.class)
    private final List<Operation> outputs = new ArrayList<Operation>();
    @XmlAttribute
    private final ConnectorEvent activationEvent;
    @XmlAttribute
    private final String version;
    @XmlAttribute
    private FailAction failAction = FailAction.FAIL;
    @XmlAttribute
    private String errorCode;

    public ConnectorDefinitionImpl(String name, String connectorId, String version, ConnectorEvent actiationEvent) {
        super(name);
        this.connectorId = connectorId;
        this.version = version;
        this.activationEvent = actiationEvent;
    }

    public ConnectorDefinitionImpl() {
        this.connectorId = "default id";
        this.version = "default version";
        this.activationEvent = ConnectorEvent.ON_ENTER;
    }

    @Override
    public String getConnectorId() {
        return this.connectorId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Map<String, Expression> getInputs() {
        return this.inputs;
    }

    @Override
    public List<Operation> getOutputs() {
        return this.outputs;
    }

    public void addInput(String name, Expression expression) {
        this.inputs.put(name, ExpressionBuilder.getNonNullCopy(expression));
    }

    public void addOutput(Operation operation) {
        this.outputs.add(OperationBuilder.getNonNullCopy(operation));
    }

    @Override
    public ConnectorEvent getActivationEvent() {
        return this.activationEvent;
    }

    @Override
    public FailAction getFailAction() {
        return this.failAction;
    }

    public void setFailAction(FailAction failAction) {
        this.failAction = failAction;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public void accept(ModelFinderVisitor visitor, long modelId) {
        visitor.find(this, modelId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConnectorDefinitionImpl that = (ConnectorDefinitionImpl)o;
        return Objects.equals(this.connectorId, that.connectorId) && Objects.equals(this.inputs, that.inputs) && Objects.equals(this.outputs, that.outputs) && Objects.equals((Object)this.activationEvent, (Object)that.activationEvent) && Objects.equals(this.version, that.version) && Objects.equals((Object)this.failAction, (Object)that.failAction) && Objects.equals(this.errorCode, that.errorCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.connectorId, this.inputs, this.outputs, this.activationEvent, this.version, this.failAction, this.errorCode});
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("connectorId", (Object)this.connectorId).append("inputs", this.inputs).append("outputs", this.outputs).append("activationEvent", (Object)this.activationEvent).append("version", (Object)this.version).append("failAction", (Object)this.failAction).append("errorCode", (Object)this.errorCode).toString();
    }
}

