/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.document;

import java.io.Serializable;
import java.util.Objects;

public class DocumentValue
implements Serializable {
    private static final long serialVersionUID = -637083535741620642L;
    private byte[] content;
    private String mimeType;
    private String fileName;
    private String url;
    private boolean hasContent;
    private Long documentId;
    private boolean hasChanged;
    private int index = -1;

    public DocumentValue(byte[] content, String mimeType, String fileName) {
        this.content = content;
        this.mimeType = mimeType;
        this.fileName = fileName;
        this.hasContent = true;
        this.hasChanged = false;
        this.documentId = null;
        this.checkIfTheFileNameIsFilledForADocumentWithContent();
    }

    public DocumentValue(String url) {
        this.url = url;
        this.hasContent = false;
        this.hasChanged = false;
        this.documentId = null;
    }

    public DocumentValue(long documentId) {
        this.hasChanged = false;
        this.documentId = documentId;
    }

    public DocumentValue(long documentId, byte[] content, String mimeType, String fileName) {
        this.hasContent = true;
        this.content = content;
        this.mimeType = mimeType;
        this.fileName = fileName;
        this.hasChanged = true;
        this.documentId = documentId;
        this.checkIfTheFileNameIsFilledForADocumentWithContent();
    }

    public DocumentValue(long documentId, String url) {
        this.url = url;
        this.hasContent = false;
        this.hasChanged = true;
        this.documentId = documentId;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean hasContent() {
        return this.hasContent;
    }

    public void setContent(byte[] content) {
        this.hasContent = true;
        this.content = content;
        this.checkIfTheFileNameIsFilledForADocumentWithContent();
    }

    private void checkIfTheFileNameIsFilledForADocumentWithContent() {
        if (this.hasContent && (this.fileName == null || this.fileName.isEmpty())) {
            throw new IllegalArgumentException("The fileName field must be filled when the content is filled !!");
        }
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.checkIfTheFileNameIsFilledForADocumentWithContent();
    }

    public void setUrl(String url) {
        this.url = url;
        this.hasContent = false;
    }

    public void setHasContent(boolean hasContent) {
        this.hasContent = hasContent;
    }

    public Long getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setHasChanged(boolean hasChanged) {
        this.hasChanged = hasChanged;
    }

    public int getIndex() {
        return this.index;
    }

    public DocumentValue setIndex(int index) {
        this.index = index;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentValue that = (DocumentValue)o;
        return Objects.equals(this.hasContent, that.hasContent) && Objects.equals(this.hasChanged, that.hasChanged) && Objects.equals(this.index, that.index) && Objects.equals(this.content, that.content) && Objects.equals(this.mimeType, that.mimeType) && Objects.equals(this.fileName, that.fileName) && Objects.equals(this.url, that.url) && Objects.equals(this.documentId, that.documentId);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.mimeType, this.fileName, this.url, this.hasContent, this.documentId, this.hasChanged, this.index);
    }

    public String toString() {
        return "DocumentValue{mimeType='" + this.mimeType + "', fileName='" + this.fileName + "', url='" + this.url + "', hasContent=" + this.hasContent + ", documentId=" + this.documentId + ", hasChanged=" + this.hasChanged + ", index=" + this.index + "}";
    }
}

