/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.flownode.impl.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.bonitasoft.engine.bpm.NamedElement;
import org.bonitasoft.engine.bpm.ObjectSeeker;
import org.bonitasoft.engine.bpm.businessdata.BusinessDataDefinition;
import org.bonitasoft.engine.bpm.businessdata.impl.BusinessDataDefinitionImpl;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.connector.impl.ConnectorDefinitionImpl;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.data.impl.DataDefinitionImpl;
import org.bonitasoft.engine.bpm.data.impl.TextDataDefinitionImpl;
import org.bonitasoft.engine.bpm.data.impl.XMLDataDefinitionImpl;
import org.bonitasoft.engine.bpm.document.DocumentDefinition;
import org.bonitasoft.engine.bpm.document.DocumentListDefinition;
import org.bonitasoft.engine.bpm.document.impl.DocumentDefinitionImpl;
import org.bonitasoft.engine.bpm.document.impl.DocumentListDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.ActivityDefinition;
import org.bonitasoft.engine.bpm.flownode.BoundaryEventDefinition;
import org.bonitasoft.engine.bpm.flownode.EndEventDefinition;
import org.bonitasoft.engine.bpm.flownode.FlowNodeDefinition;
import org.bonitasoft.engine.bpm.flownode.GatewayDefinition;
import org.bonitasoft.engine.bpm.flownode.IntermediateCatchEventDefinition;
import org.bonitasoft.engine.bpm.flownode.IntermediateThrowEventDefinition;
import org.bonitasoft.engine.bpm.flownode.StartEventDefinition;
import org.bonitasoft.engine.bpm.flownode.TransitionDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.FlowElementContainerDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.internal.AutomaticTaskDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.CallActivityDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.ElementFinder;
import org.bonitasoft.engine.bpm.flownode.impl.internal.EndEventDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.GatewayDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.IntermediateCatchEventDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.IntermediateThrowEventDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.ManualTaskDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.ReceiveTaskDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.SendTaskDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.StartEventDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.TransitionDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.UserTaskDefinitionImpl;
import org.bonitasoft.engine.bpm.internal.BaseDefinitionElementImpl;
import org.bonitasoft.engine.bpm.process.ModelFinderVisitor;
import org.bonitasoft.engine.bpm.process.Visitable;
import org.bonitasoft.engine.bpm.process.impl.internal.SubProcessDefinitionImpl;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class FlowElementContainerDefinitionImpl
extends BaseDefinitionElementImpl
implements FlowElementContainerDefinition,
Visitable {
    private static final long serialVersionUID = 1L;
    @XmlElements(value={@XmlElement(type=AutomaticTaskDefinitionImpl.class, name="automaticTask"), @XmlElement(type=CallActivityDefinitionImpl.class, name="callActivity"), @XmlElement(type=ManualTaskDefinitionImpl.class, name="manualTask"), @XmlElement(type=ReceiveTaskDefinitionImpl.class, name="receiveTask"), @XmlElement(type=SendTaskDefinitionImpl.class, name="sendTask"), @XmlElement(type=UserTaskDefinitionImpl.class, name="userTask"), @XmlElement(type=SubProcessDefinitionImpl.class, name="subProcess")})
    private final List<ActivityDefinition> activities;
    @XmlElementWrapper(name="transitions")
    @XmlElement(type=TransitionDefinitionImpl.class, name="transition")
    private final Set<TransitionDefinition> transitions;
    @XmlElement(type=GatewayDefinitionImpl.class, name="gateway")
    private final List<GatewayDefinition> gateways;
    @XmlElement(type=StartEventDefinitionImpl.class, name="startEvent")
    private final List<StartEventDefinition> startEvents;
    @XmlElement(type=IntermediateCatchEventDefinitionImpl.class, name="intermediateCatchEvent")
    private final List<IntermediateCatchEventDefinition> intermediateCatchEvents;
    @XmlElement(type=IntermediateThrowEventDefinitionImpl.class, name="intermediateThrowEvent")
    private final List<IntermediateThrowEventDefinition> intermediateThrowEvents;
    @XmlElement(type=EndEventDefinitionImpl.class, name="endEvent")
    private final List<EndEventDefinition> endEvents;
    @XmlElementWrapper(name="dataDefinitions")
    @XmlElements(value={@XmlElement(type=DataDefinitionImpl.class, name="dataDefinition"), @XmlElement(type=TextDataDefinitionImpl.class, name="textDataDefinition"), @XmlElement(type=XMLDataDefinitionImpl.class, name="xmlDataDefinition")})
    private final List<DataDefinition> dataDefinitions;
    @XmlElementWrapper(name="businessDataDefinitions")
    @XmlElement(type=BusinessDataDefinitionImpl.class, name="businessDataDefinition")
    private final List<BusinessDataDefinition> businessDataDefinitions;
    @XmlElementWrapper(name="documentDefinitions")
    @XmlElement(type=DocumentDefinitionImpl.class, name="documentDefinition")
    private final List<DocumentDefinition> documentDefinitions;
    @XmlElementWrapper(name="documentListDefinitions")
    @XmlElement(type=DocumentListDefinitionImpl.class, name="documentListDefinition")
    private final List<DocumentListDefinition> documentListDefinitions;
    @XmlElementWrapper(name="connectors")
    @XmlElement(type=ConnectorDefinitionImpl.class, name="connector")
    private final List<ConnectorDefinition> connectors;
    @XmlElement
    private final ElementFinder elementFinder = new ElementFinder();

    public FlowElementContainerDefinitionImpl() {
        this.activities = new ArrayList<ActivityDefinition>();
        this.transitions = new HashSet<TransitionDefinition>();
        this.gateways = new ArrayList<GatewayDefinition>();
        this.startEvents = new ArrayList<StartEventDefinition>(1);
        this.intermediateCatchEvents = new ArrayList<IntermediateCatchEventDefinition>(4);
        this.endEvents = new ArrayList<EndEventDefinition>(4);
        this.intermediateThrowEvents = new ArrayList<IntermediateThrowEventDefinition>(4);
        this.dataDefinitions = new ArrayList<DataDefinition>();
        this.businessDataDefinitions = new ArrayList<BusinessDataDefinition>();
        this.documentDefinitions = new ArrayList<DocumentDefinition>();
        this.documentListDefinitions = new ArrayList<DocumentListDefinition>();
        this.connectors = new ArrayList<ConnectorDefinition>();
    }

    @Override
    public FlowNodeDefinition getFlowNode(long sourceId) {
        return this.elementFinder.getElementById(this.getFlowNodes(), sourceId);
    }

    @Override
    public FlowNodeDefinition getFlowNode(String sourceName) {
        Set<FlowNodeDefinition> flowNodes = this.getFlowNodes();
        return this.getElementByName(flowNodes, sourceName);
    }

    private Set<FlowNodeDefinition> getFlowNodes() {
        HashSet<FlowNodeDefinition> flowNodes = new HashSet<FlowNodeDefinition>();
        flowNodes.addAll(this.gateways);
        flowNodes.addAll(this.activities);
        flowNodes.addAll(this.startEvents);
        flowNodes.addAll(this.intermediateCatchEvents);
        flowNodes.addAll(this.intermediateThrowEvents);
        flowNodes.addAll(this.endEvents);
        flowNodes.addAll(this.getBoundaryEvents());
        return Collections.unmodifiableSet(flowNodes);
    }

    private List<BoundaryEventDefinition> getBoundaryEvents() {
        ArrayList<BoundaryEventDefinition> boundaryEvents = new ArrayList<BoundaryEventDefinition>(3);
        for (ActivityDefinition activity : this.activities) {
            boundaryEvents.addAll(activity.getBoundaryEventDefinitions());
        }
        return boundaryEvents;
    }

    @Override
    public List<ActivityDefinition> getActivities() {
        return Collections.unmodifiableList(this.activities);
    }

    @Override
    public ActivityDefinition getActivity(String name) {
        return this.getElementByName(this.activities, name);
    }

    @Override
    public Set<TransitionDefinition> getTransitions() {
        return Collections.unmodifiableSet(this.transitions);
    }

    @Override
    @Deprecated
    public Set<GatewayDefinition> getGateways() {
        return Collections.unmodifiableSet(new HashSet<GatewayDefinition>(this.gateways));
    }

    @Override
    public List<GatewayDefinition> getGatewaysList() {
        return Collections.unmodifiableList(this.gateways);
    }

    @Override
    public GatewayDefinition getGateway(String name) {
        return this.getElementByName(this.gateways, name);
    }

    private <T extends NamedElement> T getElementByName(Collection<T> elements, String name) {
        NamedElement element = null;
        boolean found = false;
        Iterator<T> iterator = elements.iterator();
        while (!found && iterator.hasNext()) {
            NamedElement next = (NamedElement)iterator.next();
            if (!name.equals(next.getName())) continue;
            found = true;
            element = next;
        }
        return (T)element;
    }

    @Override
    public List<StartEventDefinition> getStartEvents() {
        return Collections.unmodifiableList(this.startEvents);
    }

    @Override
    public List<IntermediateCatchEventDefinition> getIntermediateCatchEvents() {
        return Collections.unmodifiableList(this.intermediateCatchEvents);
    }

    @Override
    public List<IntermediateThrowEventDefinition> getIntermediateThrowEvents() {
        return Collections.unmodifiableList(this.intermediateThrowEvents);
    }

    @Override
    public List<EndEventDefinition> getEndEvents() {
        return Collections.unmodifiableList(this.endEvents);
    }

    @Override
    public List<BusinessDataDefinition> getBusinessDataDefinitions() {
        return Collections.unmodifiableList(this.businessDataDefinitions);
    }

    @Override
    public List<DataDefinition> getDataDefinitions() {
        return Collections.unmodifiableList(this.dataDefinitions);
    }

    @Override
    public List<DocumentDefinition> getDocumentDefinitions() {
        return Collections.unmodifiableList(this.documentDefinitions);
    }

    @Override
    public List<DocumentListDefinition> getDocumentListDefinitions() {
        return Collections.unmodifiableList(this.documentListDefinitions);
    }

    @Override
    public List<ConnectorDefinition> getConnectors() {
        return Collections.unmodifiableList(this.connectors);
    }

    public void addActivity(ActivityDefinition activity) {
        this.activities.add(activity);
    }

    public void addTransition(TransitionDefinition transition) {
        this.transitions.add(transition);
    }

    public void addGateway(GatewayDefinition gateway) {
        this.gateways.add(gateway);
    }

    public void addStartEvent(StartEventDefinition startEvent) {
        this.startEvents.add(startEvent);
    }

    public void addIntermediateCatchEvent(IntermediateCatchEventDefinition event) {
        this.intermediateCatchEvents.add(event);
    }

    public void addIntermediateThrowEvent(IntermediateThrowEventDefinition intermediateThrowEvent) {
        this.intermediateThrowEvents.add(intermediateThrowEvent);
    }

    public void addEndEvent(EndEventDefinition endEvent) {
        this.endEvents.add(endEvent);
    }

    public void addBusinessDataDefinition(BusinessDataDefinition businessDataDefinition) {
        this.businessDataDefinitions.add(businessDataDefinition);
    }

    public void addDataDefinition(DataDefinition dataDefinition) {
        this.dataDefinitions.add(dataDefinition);
    }

    public void addDocumentDefinition(DocumentDefinition documentDefinition) {
        this.documentDefinitions.add(documentDefinition);
    }

    public void addDocumentListDefinition(DocumentListDefinition documentListDefinition) {
        this.documentListDefinitions.add(documentListDefinition);
    }

    public void addConnector(ConnectorDefinition connectorDefinition) {
        this.connectors.add(connectorDefinition);
    }

    @Override
    public BusinessDataDefinition getBusinessDataDefinition(String name) {
        return ObjectSeeker.getNamedElement(this.businessDataDefinitions, name);
    }

    @Override
    public DataDefinition getDataDefinition(String name) {
        return ObjectSeeker.getNamedElement(this.dataDefinitions, name);
    }

    @Override
    public void accept(ModelFinderVisitor visitor, long modelId) {
        visitor.find(this, modelId);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("activities", this.activities).append("transitions", this.transitions).append("gateways", this.gateways).append("startEvents", this.startEvents).append("intermediateCatchEvents", this.intermediateCatchEvents).append("intermediateThrowEvents", this.intermediateThrowEvents).append("endEvents", this.endEvents).append("dataDefinitions", this.dataDefinitions).append("businessDataDefinitions", this.businessDataDefinitions).append("documentDefinitions", this.documentDefinitions).append("documentListDefinitions", this.documentListDefinitions).append("connectors", this.connectors).append("elementFinder", (Object)this.elementFinder).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FlowElementContainerDefinitionImpl that = (FlowElementContainerDefinitionImpl)o;
        return Objects.equals(this.activities, that.activities) && Objects.equals(this.transitions, that.transitions) && Objects.equals(this.gateways, that.gateways) && Objects.equals(this.startEvents, that.startEvents) && Objects.equals(this.intermediateCatchEvents, that.intermediateCatchEvents) && Objects.equals(this.intermediateThrowEvents, that.intermediateThrowEvents) && Objects.equals(this.endEvents, that.endEvents) && Objects.equals(this.dataDefinitions, that.dataDefinitions) && Objects.equals(this.businessDataDefinitions, that.businessDataDefinitions) && Objects.equals(this.documentDefinitions, that.documentDefinitions) && Objects.equals(this.documentListDefinitions, that.documentListDefinitions) && Objects.equals(this.connectors, that.connectors) && Objects.equals(this.elementFinder, that.elementFinder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.activities, this.transitions, this.gateways, this.startEvents, this.intermediateCatchEvents, this.intermediateThrowEvents, this.endEvents, this.dataDefinitions, this.businessDataDefinitions, this.documentDefinitions, this.documentListDefinitions, this.connectors, this.elementFinder);
    }
}

