/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GroupUpdater
implements Serializable {
    private static final long serialVersionUID = 728214104237982027L;
    private final Map<GroupField, Serializable> fields = new HashMap<GroupField, Serializable>(3);

    public GroupUpdater updateName(String name) {
        this.fields.put(GroupField.NAME, (Serializable)((Object)name));
        return this;
    }

    public GroupUpdater updateDisplayName(String displayName) {
        this.fields.put(GroupField.DISPLAY_NAME, (Serializable)((Object)displayName));
        return this;
    }

    public GroupUpdater updateDescription(String description) {
        this.fields.put(GroupField.DESCRIPTION, (Serializable)((Object)description));
        return this;
    }

    @Deprecated
    public GroupUpdater updateIconName(String iconName) {
        return this;
    }

    @Deprecated
    public GroupUpdater updateIconPath(String iconPath) {
        return this;
    }

    public GroupUpdater updateIcon(String filename, byte[] content) {
        this.fields.put(GroupField.ICON_FILENAME, (Serializable)((Object)filename));
        this.fields.put(GroupField.ICON_CONTENT, (Serializable)content);
        return this;
    }

    public GroupUpdater updateParentPath(String parentPath) {
        this.fields.put(GroupField.PARENT_PATH, (Serializable)((Object)parentPath));
        return this;
    }

    public Map<GroupField, Serializable> getFields() {
        return this.fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupUpdater that = (GroupUpdater)o;
        return Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.fields);
    }

    public String toString() {
        return "GroupUpdater{fields=" + this.fields + "}";
    }

    public static enum GroupField {
        NAME,
        DISPLAY_NAME,
        DESCRIPTION,
        ICON_NAME,
        ICON_PATH,
        PARENT_PATH,
        ICON_FILENAME,
        ICON_CONTENT;

    }
}

