/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bonitasoft.engine.io.FileAndContent;
import org.bonitasoft.engine.io.FileOperations;

public class FileAndContentUtils {
    public static byte[] zip(FileAndContent ... files) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ZipOutputStream zos = new ZipOutputStream(baos);){
                for (FileAndContent file : files) {
                    ZipEntry e = new ZipEntry(file.getFileName());
                    zos.putNextEntry(e);
                    if (!e.isDirectory()) {
                        zos.write(file.getContent());
                    }
                    zos.flush();
                    zos.closeEntry();
                }
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public static FileAndContent file(String fileName, String content) {
        return new FileAndContent(fileName, content.getBytes());
    }

    public static FileAndContent file(String fileName, byte[] content) {
        return new FileAndContent(fileName, content);
    }

    public static FileAndContent fromFile(File file) throws IOException {
        return new FileAndContent(file.getName(), FileOperations.readFully(file));
    }

    public static FileAndContent directory(String fileName) {
        return new FileAndContent(fileName, null);
    }

    public static FileAndContent file(String fileName, InputStream content) throws IOException {
        return new FileAndContent(fileName, FileOperations.readFully(content));
    }
}

