/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileOperations {
    public static byte[] getFileFromZip(File zip, String filePath) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(zip);){
            byte[] byArray = FileOperations.getFileFromZip(inputStream, filePath);
            return byArray;
        }
    }

    public static void updateFileContent(File zip, String filePath, InputStream newContent) throws IOException {
        Path zipFilePath = zip.toPath();
        try (FileSystem fs = FileSystems.newFileSystem(zipFilePath, null);){
            Path source = fs.getPath(filePath, new String[0]);
            Path temp = fs.getPath("./temp_" + UUID.randomUUID().toString(), new String[0]);
            Files.write(temp, FileOperations.readFully(newContent), StandardOpenOption.CREATE_NEW);
            Files.move(temp, source, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static byte[] getFileFromZip(byte[] content, String filePath) throws IOException {
        return FileOperations.getFileFromZip(new ByteArrayInputStream(content), filePath);
    }

    public static byte[] getFileFromZip(InputStream inputStream, String filePath) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!zipEntry.getName().equals(filePath) || zipEntry.isDirectory()) continue;
                byte[] byArray = FileOperations.readFully(zipInputStream);
                return byArray;
            }
            throw new FileNotFoundException(String.format("Entry %s not found in zip", filePath));
        }
    }

    public static byte[] readFully(InputStream in) throws IOException {
        int n;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((n = in.read(buf)) > 0) {
            out.write(buf, 0, n);
        }
        return out.toByteArray();
    }

    public static String read(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            String string = new String(FileOperations.readFully(inputStream), StandardCharsets.UTF_8);
            return string;
        }
    }

    public static byte[] readFully(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            byte[] byArray = FileOperations.readFully(inputStream);
            return byArray;
        }
    }

    public static boolean isBarFile(String fileName) {
        return fileName.endsWith(".bar");
    }

    public static boolean isXmlFile(String fileName) {
        return fileName.endsWith(".xml");
    }

    public static boolean isZipFile(File file) {
        return file.getName().endsWith(".zip");
    }

    public static InputStream asInputStream(byte[] bytes) {
        return new ByteArrayInputStream(bytes);
    }

    public static InputStream asInputStream(String content) {
        return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
    }

    public static InputStream resource(String name) {
        return FileOperations.class.getResourceAsStream(name);
    }

    public static byte[] resourceAsBytes(String name) throws IOException {
        return FileOperations.readFully(FileOperations.resource(name));
    }
}

