/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.operation;

import org.bonitasoft.engine.operation.LeftOperand;
import org.bonitasoft.engine.operation.LeftOperandType;
import org.bonitasoft.engine.operation.impl.LeftOperandImpl;

public class LeftOperandBuilder {
    private LeftOperandImpl leftOperand;

    public LeftOperandBuilder createNewInstance() {
        this.leftOperand = new LeftOperandImpl();
        return this;
    }

    public LeftOperandBuilder createNewInstance(String name) {
        this.leftOperand = new LeftOperandImpl();
        this.leftOperand.setName(name);
        return this;
    }

    public LeftOperandBuilder setName(String name) {
        this.leftOperand.setName(name);
        return this;
    }

    public LeftOperandBuilder setType(String type) {
        this.leftOperand.setType(type);
        return this;
    }

    @Deprecated
    public LeftOperandBuilder setType(LeftOperandType type) {
        this.leftOperand.setType(type.name());
        return this;
    }

    @Deprecated
    public LeftOperandBuilder setExternal(boolean external) {
        if (this.leftOperand.getType() != null && !"DATA".equals(this.leftOperand.getType()) && !"EXTERNAL_DATA".equals(this.leftOperand.getType())) {
            throw new IllegalStateException("Can't set left operand to external when the type is not input or data this method is deprecated, it's not usefull to use it anymore");
        }
        this.leftOperand.setType(external ? "EXTERNAL_DATA" : "DATA");
        return this;
    }

    public LeftOperand done() {
        return this.leftOperand;
    }

    public LeftOperand createSearchIndexLeftOperand(int index) {
        return new LeftOperandBuilder().createNewInstance(String.valueOf(index)).setType("SEARCH_INDEX").done();
    }

    @Deprecated
    public LeftOperand createDataLeftOperand(String dataName, boolean external) {
        if (external) {
            return new LeftOperandBuilder().createNewInstance(dataName).setType("EXTERNAL_DATA").done();
        }
        return new LeftOperandBuilder().createNewInstance(dataName).setType("DATA").done();
    }

    public LeftOperand createDataLeftOperand(String dataName) {
        return new LeftOperandBuilder().createNewInstance(dataName).setType("DATA").done();
    }

    public LeftOperand createBusinessDataLeftOperand(String dataName) {
        return new LeftOperandBuilder().createNewInstance(dataName).setType("BUSINESS_DATA").done();
    }
}

