/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.profile.xml;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.bonitasoft.engine.api.ImportError;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ProfileEntryNode {
    @XmlAttribute
    private String name;
    @XmlAttribute
    private boolean isCustom;
    @Deprecated
    @XmlElement
    private String parentName;
    @XmlElement
    private Long index = 0L;
    @XmlElement
    private String description;
    @XmlElement
    private String type;
    @XmlElement
    private String page;

    public ProfileEntryNode() {
    }

    public ProfileEntryNode(String name) {
        this.name = name;
    }

    public final boolean isCustom() {
        return this.isCustom;
    }

    public final void setCustom(boolean isCustom) {
        this.isCustom = isCustom;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final String getType() {
        return this.type;
    }

    public final void setType(String type) {
        this.type = type;
    }

    public final long getIndex() {
        return this.index;
    }

    public final void setIndex(long index) {
        this.index = index;
    }

    public final String getPage() {
        return this.page;
    }

    public final void setPage(String page) {
        this.page = page;
    }

    public final String getName() {
        return this.name;
    }

    public boolean hasError() {
        return this.getError() != null;
    }

    public ImportError getError() {
        if (this.getName() == null) {
            return new ImportError(this.getName(), ImportError.Type.PAGE);
        }
        if (this.getPage() == null || this.getPage().isEmpty()) {
            return new ImportError(this.getName(), ImportError.Type.PAGE);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileEntryNode that = (ProfileEntryNode)o;
        return this.isCustom == that.isCustom && Objects.equals(this.name, that.name) && Objects.equals(this.index, that.index) && Objects.equals(this.description, that.description) && Objects.equals(this.type, that.type) && Objects.equals(this.page, that.page);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.isCustom, this.index, this.description, this.type, this.page);
    }

    public String toString() {
        return "ProfileEntryNode{name='" + this.name + "', isCustom=" + this.isCustom + ", index=" + this.index + ", description='" + this.description + "', type='" + this.type + "', page='" + this.page + "'}";
    }
}

