/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.Index;
import org.bonitasoft.engine.bdm.model.UniqueConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BusinessObjectModel {
    public static final String CURRENT_MODEL_VERSION = "1.0";
    public static final String CURRENT_PRODUCT_VERSION;
    private static final Logger LOGGER;
    @XmlElementWrapper(name="businessObjects", required=true)
    @XmlElement(name="businessObject", required=true)
    private List<BusinessObject> businessObjects = new ArrayList<BusinessObject>();
    @XmlAttribute(name="modelVersion", required=false)
    private String modelVersion;
    @XmlAttribute(name="productVersion", required=false)
    private String productVersion;

    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public List<BusinessObject> getBusinessObjects() {
        return this.businessObjects;
    }

    public void setBusinessObjects(List<BusinessObject> businessObjects) {
        this.businessObjects = businessObjects;
    }

    public void addBusinessObject(BusinessObject businessObject) {
        this.businessObjects.add(businessObject);
    }

    public Set<String> getBusinessObjectsClassNames() {
        HashSet<String> set = new HashSet<String>();
        for (BusinessObject o : this.businessObjects) {
            set.add(o.getQualifiedName());
        }
        return set;
    }

    public List<BusinessObject> getReferencedBusinessObjectsByComposition() {
        ArrayList<BusinessObject> refs = new ArrayList<BusinessObject>();
        for (BusinessObject bo : this.businessObjects) {
            refs.addAll(bo.getReferencedBusinessObjectsByComposition());
        }
        return refs;
    }

    public List<UniqueConstraint> getUniqueConstraints() {
        ArrayList<UniqueConstraint> constraints = new ArrayList<UniqueConstraint>();
        for (BusinessObject bo : this.businessObjects) {
            constraints.addAll(bo.getUniqueConstraints());
        }
        return constraints;
    }

    public List<Index> getIndexes() {
        ArrayList<Index> indexes = new ArrayList<Index>();
        for (BusinessObject bo : this.businessObjects) {
            indexes.addAll(bo.getIndexes());
        }
        return indexes;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.businessObjects).append((Object)this.modelVersion).append((Object)this.productVersion).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BusinessObjectModel) {
            BusinessObjectModel other = (BusinessObjectModel)obj;
            return new EqualsBuilder().append(this.businessObjects, other.businessObjects).append((Object)this.modelVersion, (Object)other.modelVersion).append((Object)this.productVersion, (Object)other.productVersion).isEquals();
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("businessObjects", this.businessObjects).toString();
    }

    static {
        LOGGER = LoggerFactory.getLogger(BusinessObjectModel.class);
        Properties info = new Properties();
        try {
            info.load(BusinessObjectModel.class.getResourceAsStream("/info.properties"));
        }
        catch (IOException e) {
            LOGGER.error("Failed to retrieve product version", (Throwable)e);
        }
        String version = info.getProperty("version");
        CURRENT_PRODUCT_VERSION = !StringUtils.isBlank((CharSequence)version) ? version : null;
    }
}

