/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class CustomOffsetDateTimeSerializer
extends StdSerializer<OffsetDateTime> {
    public CustomOffsetDateTimeSerializer() {
        this(null);
    }

    public CustomOffsetDateTimeSerializer(Class<OffsetDateTime> t) {
        super(t);
    }

    public void serialize(OffsetDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeString(value != null ? DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(value.withOffsetSameInstant(ZoneOffset.UTC)) : null);
    }
}

