/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;

public class SQLNameValidator {
    private final int maxLength;
    static Set<String> sqlKeywords = new HashSet<String>();

    public SQLNameValidator() {
        this(255);
    }

    public SQLNameValidator(int maxLength) {
        this.maxLength = maxLength;
        if (sqlKeywords.isEmpty()) {
            this.initializeSQLKeywords();
        }
    }

    private void initializeSQLKeywords() {
        try (InputStream resourceAsStream = SQLNameValidator.class.getResourceAsStream("/sql_keywords");
             Scanner scanner = new Scanner(resourceAsStream);){
            while (scanner.hasNext()) {
                String word = scanner.nextLine();
                sqlKeywords.add(word.trim());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isValid(String name) {
        return name.matches("[a-zA-Z][\\d\\w#@]{0," + this.maxLength + "}$") && !this.isSQLKeyword(name);
    }

    public boolean isSQLKeyword(String name) {
        return sqlKeywords.contains(name.toUpperCase());
    }
}

