/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.bonitasoft.engine.api.result.StatusCode;
import org.bonitasoft.engine.bdm.BDMQueryUtil;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.BusinessObjectModel;
import org.bonitasoft.engine.bdm.model.Query;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;

public class BusinessObjectModelValidationRule
extends ValidationRule<BusinessObjectModel, ValidationStatus> {
    public BusinessObjectModelValidationRule() {
        super(BusinessObjectModel.class);
    }

    @Override
    public ValidationStatus validate(BusinessObjectModel bom) {
        ValidationStatus status = new ValidationStatus();
        if (bom.getBusinessObjects().isEmpty()) {
            status.addError(StatusCode.EMPTY_BDM, "Business object model must have at least one business object declared");
        } else {
            this.validateQueries(bom, status);
        }
        return status;
    }

    private void validateQueries(BusinessObjectModel bom, ValidationStatus status) {
        for (BusinessObject bo : bom.getBusinessObjects()) {
            List<Query> lazyQueries = BDMQueryUtil.createProvidedQueriesForLazyField(bom, bo);
            HashSet<String> lazyQueryNames = new HashSet<String>();
            for (Query query : lazyQueries) {
                lazyQueryNames.add(query.getName());
            }
            HashMap<String, Serializable> context = new HashMap<String, Serializable>();
            context.put("businessObjectName", (Serializable)((Object)bo.getQualifiedName()));
            for (Query q : bo.getQueries()) {
                if (!lazyQueryNames.contains(q.getName())) continue;
                context.put("bdmArtifactName", (Serializable)((Object)q.getName()));
                status.addError(StatusCode.DUPLICATE_QUERY_NAME, "The query named \"" + q.getName() + "\" already exists for " + bo.getQualifiedName(), context);
            }
        }
    }
}

