/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule;

import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.api.result.StatusCode;
import org.bonitasoft.engine.bdm.model.Index;
import org.bonitasoft.engine.bdm.validator.SQLNameValidator;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;

public class IndexValidationRule
extends ValidationRule<Index, ValidationStatus> {
    private static final int MAX_CONSTRAINTNAME_LENGTH = 25;
    private final SQLNameValidator sqlNameValidator = new SQLNameValidator(25);

    public IndexValidationRule() {
        super(Index.class);
    }

    @Override
    protected ValidationStatus validate(Index index) {
        List<String> fieldNames;
        ValidationStatus status = new ValidationStatus();
        String name = index.getName();
        if (name == null || name.isEmpty()) {
            status.addError(StatusCode.INDEX_WITHOUT_NAME, "An index must have name");
            return status;
        }
        if (!this.sqlNameValidator.isValid(name)) {
            status.addError(StatusCode.INVALID_SQL_IDENTIFIER_NAME, String.format("%s is not a valid SQL identifier", name), Collections.singletonMap("bdmArtifactName", name));
        }
        if ((fieldNames = index.getFieldNames()) == null || fieldNames.isEmpty()) {
            status.addError(StatusCode.INDEX_WITHOUT_FIELD, String.format("%s index must have at least one field declared", name), Collections.singletonMap("bdmArtifactName", name));
        }
        return status;
    }
}

