/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule;

import java.util.Collections;
import javax.lang.model.SourceVersion;
import org.bonitasoft.engine.api.result.StatusCode;
import org.bonitasoft.engine.bdm.model.Query;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;

public class QueryValidationRule
extends ValidationRule<Query, ValidationStatus> {
    private static final int MAX_QUERY_NAME_LENGTH = 150;

    public QueryValidationRule() {
        super(Query.class);
    }

    @Override
    public ValidationStatus validate(Query query) {
        ValidationStatus status = new ValidationStatus();
        String name = query.getName();
        if (name == null || name.isEmpty()) {
            status.addError(StatusCode.QUERY_WITHOUT_NAME, "A query must have name");
            return status;
        }
        if (!SourceVersion.isIdentifier(name)) {
            status.addError(StatusCode.INVALID_JAVA_IDENTIFIER_NAME, String.format("%s is not a valid Java identifier.", name), Collections.singletonMap("bdmArtifactName", name));
        }
        if (name.length() > 150) {
            status.addError(StatusCode.QUERY_NAME_LENGTH_TO_HIGH, String.format("%s length must be lower than 150 characters.", name), Collections.singletonMap("bdmArtifactName", name));
        }
        if (query.getContent() == null || query.getContent().isEmpty()) {
            status.addError(StatusCode.QUERY_WITHOUT_CONTENT, String.format("%s query must have a content defined", name), Collections.singletonMap("bdmArtifactName", name));
        }
        if (query.getReturnType() == null || query.getReturnType().isEmpty()) {
            status.addError(StatusCode.QUERY_WITHOUT_RETURN_TYPE, String.format("%s query must have a return type defined", name), Collections.singletonMap("bdmArtifactName", name));
        }
        return status;
    }
}

