/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.io.File;
import java.io.IOException;
import org.bonitasoft.engine.bpm.bar.ActorMappingMarshaller;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.GenericFileContribution;
import org.bonitasoft.engine.bpm.bar.XmlMarshallException;
import org.bonitasoft.engine.bpm.bar.actorMapping.ActorMapping;
import org.bonitasoft.engine.io.IOUtil;

public class ActorMappingContribution
extends GenericFileContribution {
    public static final String ACTOR_MAPPING_FILE = "actorMapping.xml";

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public String getName() {
        return "ActorMapping";
    }

    @Override
    public String getFileName() {
        return ACTOR_MAPPING_FILE;
    }

    @Override
    public boolean readFromBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        File file = new File(barFolder, ACTOR_MAPPING_FILE);
        if (file.exists()) {
            byte[] content = IOUtil.getContent(file);
            try {
                businessArchive.setActorMapping(new ActorMappingMarshaller().deserializeFromXML(content));
            }
            catch (XmlMarshallException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void saveToBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        ActorMapping actorMapping = businessArchive.getActorMapping();
        if (actorMapping != null) {
            try {
                byte[] fileContent = new ActorMappingMarshaller().serializeToXML(actorMapping);
                File file = new File(barFolder, ACTOR_MAPPING_FILE);
                IOUtil.write(file, fileContent);
            }
            catch (XmlMarshallException e) {
                throw new IOException("Cannot write Actor Mapping to Bar folder", e);
            }
        }
    }
}

