/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveContribution;
import org.bonitasoft.engine.bpm.bar.FormMappingModelMarshaller;
import org.bonitasoft.engine.bpm.bar.form.model.FormMappingModel;
import org.bonitasoft.engine.io.IOUtil;
import org.xml.sax.SAXException;

public class FormMappingContribution
implements BusinessArchiveContribution {
    public static final String FORM_MAPPING_FILE = "form-mapping.xml";

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public String getName() {
        return "FormMapping";
    }

    @Override
    public boolean readFromBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        File file = new File(barFolder, FORM_MAPPING_FILE);
        if (file.exists()) {
            byte[] content = IOUtil.getContent(file);
            try {
                businessArchive.setFormMappings(new FormMappingModelMarshaller().deserializeFromXML(content));
            }
            catch (JAXBException | SAXException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void saveToBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        FormMappingModel formMappingModel = businessArchive.getFormMappingModel();
        try {
            byte[] fileContent = new FormMappingModelMarshaller().serializeToXML(formMappingModel);
            File file = new File(barFolder, FORM_MAPPING_FILE);
            IOUtil.write(file, fileContent);
        }
        catch (JAXBException | SAXException e) {
            throw new IOException("Cannot write Form Mapping Model to Bar folder", e);
        }
    }
}

