/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveContribution;
import org.bonitasoft.engine.bpm.bar.InvalidBusinessArchiveFormatException;
import org.bonitasoft.engine.bpm.flownode.ActivityDefinition;
import org.bonitasoft.engine.bpm.flownode.BoundaryEventDefinition;
import org.bonitasoft.engine.bpm.flownode.EndEventDefinition;
import org.bonitasoft.engine.bpm.flownode.ErrorEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.FlowElementContainerDefinition;
import org.bonitasoft.engine.bpm.flownode.IntermediateCatchEventDefinition;
import org.bonitasoft.engine.bpm.flownode.IntermediateThrowEventDefinition;
import org.bonitasoft.engine.bpm.flownode.MessageEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.SignalEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.StartEventDefinition;
import org.bonitasoft.engine.bpm.flownode.TimerEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.internal.BoundaryEventDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.EndEventDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.IntermediateCatchEventDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.IntermediateThrowEventDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.StartEventDefinitionImpl;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;
import org.bonitasoft.engine.bpm.process.impl.internal.DesignProcessDefinitionImpl;
import org.bonitasoft.engine.bpm.process.impl.internal.SubProcessDefinitionImpl;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.io.IOUtil;
import org.xml.sax.SAXException;

public class ProcessDefinitionBARContribution
implements BusinessArchiveContribution {
    public static final String PROCESS_DEFINITION_XML = "process-design.xml";
    public static final String PROCESS_INFOS_FILE = "process-infos.txt";
    private final JAXBContext jaxbContext;

    public ProcessDefinitionBARContribution() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DesignProcessDefinitionImpl.class});
        }
        catch (Exception e) {
            throw new BonitaRuntimeException(e);
        }
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public boolean readFromBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException, InvalidBusinessArchiveFormatException {
        File file = new File(barFolder, PROCESS_DEFINITION_XML);
        if (!file.exists()) {
            return false;
        }
        DesignProcessDefinition processDefinition = this.deserializeProcessDefinition(file);
        businessArchive.setProcessDefinition(processDefinition);
        this.checkProcessInfos(barFolder, processDefinition);
        return true;
    }

    protected void checkProcessInfos(File barFolder, DesignProcessDefinition processDefinition) throws InvalidBusinessArchiveFormatException {
        String processInfos = this.getProcessInfos(this.generateInfosFromDefinition(processDefinition));
        try {
            String fileContent = IOUtil.read(new File(barFolder, PROCESS_INFOS_FILE));
            if (!processInfos.equals(fileContent.trim())) {
                throw new InvalidBusinessArchiveFormatException("Invalid Business Archive format");
            }
        }
        catch (IOException e) {
            throw new InvalidBusinessArchiveFormatException("Invalid Business Archive format");
        }
    }

    public DesignProcessDefinition deserializeProcessDefinition(File file) throws IOException, InvalidBusinessArchiveFormatException {
        String content = IOUtil.read(file);
        try {
            return this.convertXmlToProcess(content);
        }
        catch (IOException e) {
            this.checkVersion(content);
            throw new InvalidBusinessArchiveFormatException(e);
        }
    }

    void checkVersion(String content) throws InvalidBusinessArchiveFormatException {
        Pattern pattern = Pattern.compile("http://www\\.bonitasoft\\.org/ns/process/client/(\\d\\.\\d)");
        Matcher matcher = pattern.matcher(content);
        boolean find = matcher.find();
        if (!find) {
            throw new InvalidBusinessArchiveFormatException("There is no bonitasoft process namespace declaration");
        }
        String group = matcher.group(1);
        if (!group.equals("7.4")) {
            throw new InvalidBusinessArchiveFormatException("Wrong version of your process definition, " + group + " namespace is not compatible with your current version. Use the studio to update it.");
        }
    }

    @Override
    public void saveToBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        DesignProcessDefinition processDefinition = businessArchive.getProcessDefinition();
        this.serializeProcessDefinition(barFolder, processDefinition);
    }

    public void serializeProcessDefinition(File barFolder, DesignProcessDefinition processDefinition) throws IOException {
        try {
            IOUtil.writeContentToFile(this.convertProcessToXml(processDefinition), new File(barFolder, PROCESS_DEFINITION_XML));
            String infos = this.generateInfosFromDefinition(processDefinition);
            IOUtil.writeContentToFile(this.getProcessInfos(infos), new File(barFolder, PROCESS_INFOS_FILE));
        }
        catch (FileNotFoundException e) {
            throw new IOException(e);
        }
    }

    public String convertProcessToXml(DesignProcessDefinition processDefinition) throws IOException {
        StringWriter writer = new StringWriter();
        try {
            Marshaller marshaller = this.getMarshaller();
            marshaller.marshal((Object)processDefinition, (Writer)writer);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
        return writer.toString();
    }

    protected Marshaller getMarshaller() throws JAXBException {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)StandardCharsets.UTF_8.name());
        return marshaller;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DesignProcessDefinition convertXmlToProcess(String content) throws IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));){
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(this.getClass().getResource("/ProcessDefinition.xsd")));
            DesignProcessDefinition process = (DesignProcessDefinition)unmarshaller.unmarshal((InputStream)stream);
            if (process.getActorInitiator() != null) {
                process.getActorInitiator().setInitiator(true);
            }
            this.addEventTriggerOnEvents(process.getFlowElementContainer());
            DesignProcessDefinition designProcessDefinition = process;
            return designProcessDefinition;
        }
        catch (UnsupportedOperationException | JAXBException | SAXException e) {
            throw new IOException("Failed to deserialize the XML string provided", e);
        }
    }

    private void addEventTriggerOnEvents(FlowElementContainerDefinition flowElementContainer) {
        this.addEventTriggerOnIntermediateCatchEvent(flowElementContainer);
        this.addEventTriggerOnIntermediateThrowEvent(flowElementContainer);
        this.addEventTriggerOnEndEvent(flowElementContainer);
        this.addEventTriggerOnBoundaryEvent(flowElementContainer);
        this.addEventTriggerOnStartEvent(flowElementContainer);
    }

    private void addEventTriggerOnStartEvent(FlowElementContainerDefinition flowElementContainer) {
        for (StartEventDefinition startEvent : flowElementContainer.getStartEvents()) {
            StartEventDefinitionImpl startEventImpl = (StartEventDefinitionImpl)startEvent;
            for (MessageEventTriggerDefinition messageEventTriggerDefinition : startEvent.getMessageEventTriggerDefinitions()) {
                startEventImpl.addEventTrigger(messageEventTriggerDefinition);
            }
            for (ErrorEventTriggerDefinition errorEventTriggerDefinition : startEvent.getErrorEventTriggerDefinitions()) {
                startEventImpl.addEventTrigger(errorEventTriggerDefinition);
            }
            for (SignalEventTriggerDefinition signalEventTriggerDefinition : startEvent.getSignalEventTriggerDefinitions()) {
                startEventImpl.addEventTrigger(signalEventTriggerDefinition);
            }
            for (TimerEventTriggerDefinition timerEventTriggerDefinition : startEvent.getTimerEventTriggerDefinitions()) {
                startEventImpl.addEventTrigger(timerEventTriggerDefinition);
            }
        }
    }

    private void addEventTriggerOnBoundaryEvent(FlowElementContainerDefinition flowElementContainer) {
        for (ActivityDefinition activity : flowElementContainer.getActivities()) {
            for (BoundaryEventDefinition boundaryEvent : activity.getBoundaryEventDefinitions()) {
                BoundaryEventDefinitionImpl boundaryEventImpl = (BoundaryEventDefinitionImpl)boundaryEvent;
                for (MessageEventTriggerDefinition messageEventTriggerDefinition : boundaryEvent.getMessageEventTriggerDefinitions()) {
                    boundaryEventImpl.addEventTrigger(messageEventTriggerDefinition);
                }
                for (ErrorEventTriggerDefinition errorEventTriggerDefinition : boundaryEvent.getErrorEventTriggerDefinitions()) {
                    boundaryEventImpl.addEventTrigger(errorEventTriggerDefinition);
                }
                for (SignalEventTriggerDefinition signalEventTriggerDefinition : boundaryEventImpl.getSignalEventTriggerDefinitions()) {
                    boundaryEventImpl.addEventTrigger(signalEventTriggerDefinition);
                }
                for (TimerEventTriggerDefinition timerEventTriggerDefinition : boundaryEvent.getTimerEventTriggerDefinitions()) {
                    boundaryEventImpl.addEventTrigger(timerEventTriggerDefinition);
                }
            }
            if (activity.getClass() != SubProcessDefinitionImpl.class) continue;
            this.addEventTriggerOnEvents(((SubProcessDefinitionImpl)activity).getSubProcessContainer());
        }
    }

    private void addEventTriggerOnEndEvent(FlowElementContainerDefinition flowElementContainer) {
        for (EndEventDefinition endEvent : flowElementContainer.getEndEvents()) {
            EndEventDefinitionImpl endEventImpl = (EndEventDefinitionImpl)endEvent;
            for (ErrorEventTriggerDefinition errorEventTriggerDefinition : endEventImpl.getErrorEventTriggerDefinitions()) {
                endEventImpl.addEventTrigger(errorEventTriggerDefinition);
            }
            for (SignalEventTriggerDefinition signalEventTriggerDefinition : endEventImpl.getSignalEventTriggerDefinitions()) {
                endEventImpl.addEventTrigger(signalEventTriggerDefinition);
            }
            for (MessageEventTriggerDefinition messageEventTriggerDefinition : endEventImpl.getMessageEventTriggerDefinitions()) {
                endEventImpl.addEventTrigger(messageEventTriggerDefinition);
            }
        }
    }

    private void addEventTriggerOnIntermediateThrowEvent(FlowElementContainerDefinition flowElementContainer) {
        for (IntermediateThrowEventDefinition throwEvent : flowElementContainer.getIntermediateThrowEvents()) {
            IntermediateThrowEventDefinitionImpl throwEventImpl = (IntermediateThrowEventDefinitionImpl)throwEvent;
            for (MessageEventTriggerDefinition messageEventTriggerDefinition : throwEventImpl.getMessageEventTriggerDefinitions()) {
                throwEventImpl.addEventTrigger(messageEventTriggerDefinition);
            }
            for (SignalEventTriggerDefinition signalEventTriggerDefinition : throwEventImpl.getSignalEventTriggerDefinitions()) {
                throwEventImpl.addEventTrigger(signalEventTriggerDefinition);
            }
        }
    }

    private void addEventTriggerOnIntermediateCatchEvent(FlowElementContainerDefinition flowElementContainer) {
        for (IntermediateCatchEventDefinition catchEvent : flowElementContainer.getIntermediateCatchEvents()) {
            IntermediateCatchEventDefinitionImpl catchEventImpl = (IntermediateCatchEventDefinitionImpl)catchEvent;
            for (MessageEventTriggerDefinition messageEventTriggerDefinition : catchEvent.getMessageEventTriggerDefinitions()) {
                catchEventImpl.addEventTrigger(messageEventTriggerDefinition);
            }
            for (ErrorEventTriggerDefinition errorEventTriggerDefinition : catchEvent.getErrorEventTriggerDefinitions()) {
                catchEventImpl.addEventTrigger(errorEventTriggerDefinition);
            }
            for (SignalEventTriggerDefinition signalEventTriggerDefinition : catchEventImpl.getSignalEventTriggerDefinitions()) {
                catchEventImpl.addEventTrigger(signalEventTriggerDefinition);
            }
            for (TimerEventTriggerDefinition timerEventTriggerDefinition : catchEventImpl.getTimerEventTriggerDefinitions()) {
                catchEventImpl.addEventTrigger(timerEventTriggerDefinition);
            }
        }
    }

    protected String generateInfosFromDefinition(DesignProcessDefinition processDefinition) {
        FlowElementContainerDefinition processContainer = processDefinition.getFlowElementContainer();
        return "key1:" + processDefinition.getActorsList().size() + ",key2:" + processContainer.getTransitions().size() + ",key3:" + processContainer.getActivities().size();
    }

    protected String getProcessInfos(String infos) {
        return Base64.encodeBase64String((byte[])DigestUtils.md5((String)infos)).trim();
    }

    @Override
    public String getName() {
        return "Process design";
    }
}

