/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar.actorMapping;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.apache.commons.lang3.builder.ToStringBuilder;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Actor
implements Serializable {
    @XmlAttribute
    private String name;
    @XmlAttribute
    private String description;
    @XmlElementWrapper(name="users", required=false)
    @XmlElement(name="user")
    private Set<String> users = new HashSet<String>();
    @XmlElementWrapper(name="groups", required=false)
    @XmlElement(name="group")
    private Set<String> groups = new HashSet<String>();
    @XmlElementWrapper(name="roles", required=false)
    @XmlElement(name="role")
    private Set<String> roles = new HashSet<String>();
    @XmlElementWrapper(name="memberships", required=false)
    @XmlElement(name="membership")
    private Set<Membership> memberships = null;

    public Actor(String name) {
        this.name = name;
        this.memberships = new HashSet<Membership>();
    }

    public Actor() {
        this.memberships = new HashSet<Membership>();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addGroup(String group) {
        this.groups.add(group);
    }

    public void addGroups(List<String> groups) {
        this.groups = new HashSet<String>(groups);
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void addRole(String role) {
        this.roles.add(role);
    }

    public void addRoles(List<String> roles) {
        this.roles = new HashSet<String>(roles);
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void addUser(String user) {
        this.users.add(user);
    }

    public void addUsers(List<String> userNames) {
        this.users = new HashSet<String>(userNames);
    }

    public Set<String> getUsers() {
        return this.users;
    }

    public void addMembership(String groupName, String roleName) {
        this.memberships.add(new Membership(groupName, roleName));
    }

    public Set<Membership> getMemberships() {
        return this.memberships;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Actor actor = (Actor)o;
        return Objects.equals(this.name, actor.name) && Objects.equals(this.description, actor.description) && Objects.equals(this.users, actor.users) && Objects.equals(this.groups, actor.groups) && Objects.equals(this.roles, actor.roles) && Objects.equals(this.memberships, actor.memberships);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.users, this.groups, this.roles, this.memberships);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("description", (Object)this.description).append("users", this.users).append("groups", this.groups).append("roles", this.roles).append("memberships", this.memberships).toString();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Membership
    implements Serializable {
        private String role;
        private String group;

        public Membership() {
        }

        public Membership(String group, String role) {
            this.group = group;
            this.role = role;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Membership that = (Membership)o;
            return Objects.equals(this.role, that.role) && Objects.equals(this.group, that.group);
        }

        public int hashCode() {
            return Objects.hash(this.role, this.group);
        }
    }
}

