/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.process.impl;

import java.io.Serializable;
import java.util.Date;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.bpm.flownode.GatewayType;
import org.bonitasoft.engine.bpm.flownode.impl.internal.FlowElementContainerDefinitionImpl;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;
import org.bonitasoft.engine.bpm.process.InvalidProcessDefinitionException;
import org.bonitasoft.engine.bpm.process.impl.AutomaticTaskDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.CallActivityBuilder;
import org.bonitasoft.engine.bpm.process.impl.ConnectorDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.DataDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.EndEventDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.FlowElementBuilder;
import org.bonitasoft.engine.bpm.process.impl.GatewayDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.IntermediateCatchEventDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.IntermediateThrowEventDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.ManualTaskDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.ProcessDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.ReceiveTaskDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.SendTaskDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.StartEventDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.SubProcessActivityDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.TextDataDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.TransitionDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.UserTaskDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.XMLDataDefinitionBuilder;
import org.bonitasoft.engine.expression.Expression;

public class FlowElementContainerBuilder
implements FlowElementBuilder {
    private final FlowElementContainerDefinitionImpl container;
    private final ProcessDefinitionBuilder processDefinitionBuilder;

    public FlowElementContainerBuilder(FlowElementContainerDefinitionImpl container, ProcessDefinitionBuilder processDefinitionBuilder) {
        this.container = container;
        this.processDefinitionBuilder = processDefinitionBuilder;
    }

    public DesignProcessDefinition getProcess() throws InvalidProcessDefinitionException {
        return this.processDefinitionBuilder.done();
    }

    @Override
    public UserTaskDefinitionBuilder addUserTask(String taskName, String actorName) {
        return new UserTaskDefinitionBuilder(this.processDefinitionBuilder, this.container, taskName, actorName);
    }

    @Override
    public AutomaticTaskDefinitionBuilder addAutomaticTask(String taskName) {
        return new AutomaticTaskDefinitionBuilder(this.processDefinitionBuilder, this.container, taskName);
    }

    @Override
    public ReceiveTaskDefinitionBuilder addReceiveTask(String activityName, String messageName) {
        return new ReceiveTaskDefinitionBuilder(this.processDefinitionBuilder, this.container, activityName, messageName);
    }

    @Override
    public SendTaskDefinitionBuilder addSendTask(String taskName, String messageName, Expression targetProcess) {
        return new SendTaskDefinitionBuilder(this.processDefinitionBuilder, this.container, taskName, messageName, targetProcess);
    }

    @Override
    public ManualTaskDefinitionBuilder addManualTask(String name, String actorName) {
        return new ManualTaskDefinitionBuilder(this.processDefinitionBuilder, this.container, name, actorName);
    }

    @Override
    public TransitionDefinitionBuilder addTransition(String source, String target) {
        return new TransitionDefinitionBuilder(this.processDefinitionBuilder, this.container, source, target, false);
    }

    @Override
    public TransitionDefinitionBuilder addTransition(String source, String target, Expression condition) {
        return new TransitionDefinitionBuilder(this.processDefinitionBuilder, this.container, source, target, condition, false);
    }

    @Override
    public TransitionDefinitionBuilder addDefaultTransition(String source, String target) {
        return new TransitionDefinitionBuilder(this.processDefinitionBuilder, this.container, source, target, null, true);
    }

    @Override
    public GatewayDefinitionBuilder addGateway(String name, GatewayType gatewayType) {
        return new GatewayDefinitionBuilder(this.processDefinitionBuilder, this.container, name, gatewayType);
    }

    @Override
    public StartEventDefinitionBuilder addStartEvent(String name) {
        return new StartEventDefinitionBuilder(this.processDefinitionBuilder, this.container, name);
    }

    @Override
    public EndEventDefinitionBuilder addEndEvent(String name) {
        return new EndEventDefinitionBuilder(this.processDefinitionBuilder, this.container, name);
    }

    @Override
    public IntermediateCatchEventDefinitionBuilder addIntermediateCatchEvent(String name) {
        return new IntermediateCatchEventDefinitionBuilder(this.processDefinitionBuilder, this.container, name);
    }

    @Override
    public IntermediateThrowEventDefinitionBuilder addIntermediateThrowEvent(String name) {
        return new IntermediateThrowEventDefinitionBuilder(this.processDefinitionBuilder, this.container, name);
    }

    @Override
    public CallActivityBuilder addCallActivity(String name, Expression callableElement, Expression callableElementVersion) {
        return new CallActivityBuilder(this.processDefinitionBuilder, this.container, name, callableElement, callableElementVersion);
    }

    @Override
    public SubProcessActivityDefinitionBuilder addSubProcess(String name, boolean triggeredByEvent) {
        return new SubProcessActivityDefinitionBuilder(this.processDefinitionBuilder, this.container, name, triggeredByEvent);
    }

    @Override
    public ConnectorDefinitionBuilder addConnector(String name, String connectorId, String version, ConnectorEvent activationEvent) {
        return new ConnectorDefinitionBuilder(this.processDefinitionBuilder, this.container, name, connectorId, version, activationEvent);
    }

    @Override
    public DataDefinitionBuilder addIntegerData(String name, Expression defaultValue) {
        String className = Integer.class.getName();
        return new DataDefinitionBuilder(this.processDefinitionBuilder, this.container, name, className, defaultValue);
    }

    @Override
    public DataDefinitionBuilder addLongData(String name, Expression defaultValue) {
        String className = Long.class.getName();
        return new DataDefinitionBuilder(this.processDefinitionBuilder, this.container, name, className, defaultValue);
    }

    @Override
    public DataDefinitionBuilder addShortTextData(String name, Expression defaultValue) {
        String className = String.class.getName();
        return new TextDataDefinitionBuilder(this.processDefinitionBuilder, this.container, name, className, defaultValue);
    }

    @Override
    public TextDataDefinitionBuilder addLongTextData(String name, Expression defaultValue) {
        String className = String.class.getName();
        return new TextDataDefinitionBuilder(this.processDefinitionBuilder, this.container, name, className, defaultValue).isLongText();
    }

    @Override
    public DataDefinitionBuilder addDoubleData(String name, Expression defaultValue) {
        String className = Double.class.getName();
        return new DataDefinitionBuilder(this.processDefinitionBuilder, this.container, name, className, defaultValue);
    }

    @Override
    public DataDefinitionBuilder addFloatData(String name, Expression defaultValue) {
        String className = Float.class.getName();
        return new DataDefinitionBuilder(this.processDefinitionBuilder, this.container, name, className, defaultValue);
    }

    @Override
    public DataDefinitionBuilder addDateData(String name, Expression defaultValue) {
        String className = Date.class.getName();
        return new DataDefinitionBuilder(this.processDefinitionBuilder, this.container, name, className, defaultValue);
    }

    @Override
    public XMLDataDefinitionBuilder addXMLData(String name, Expression defaultValue) {
        String className = String.class.getName();
        return new XMLDataDefinitionBuilder(this.processDefinitionBuilder, this.container, name, className, defaultValue);
    }

    @Override
    public DataDefinitionBuilder addBlobData(String name, Expression defaultValue) {
        String className = Serializable.class.getName();
        return new DataDefinitionBuilder(this.processDefinitionBuilder, this.container, name, className, defaultValue);
    }

    @Override
    public DataDefinitionBuilder addBooleanData(String name, Expression defaultValue) {
        String className = Boolean.class.getName();
        return new DataDefinitionBuilder(this.processDefinitionBuilder, this.container, name, className, defaultValue);
    }

    @Override
    public DataDefinitionBuilder addData(String name, String className, Expression defaultValue) {
        return new DataDefinitionBuilder(this.processDefinitionBuilder, this.container, name, className, defaultValue);
    }

    protected FlowElementContainerDefinitionImpl getContainer() {
        return this.container;
    }

    protected ProcessDefinitionBuilder getProcessBuilder() {
        return this.processDefinitionBuilder;
    }
}

