/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GroupCreator
implements Serializable {
    private static final long serialVersionUID = -1546623947528297571L;
    private final Map<GroupField, Serializable> fields = new HashMap<GroupField, Serializable>(3);

    public GroupCreator(String name) {
        this.fields.put(GroupField.NAME, (Serializable)((Object)name));
    }

    public void setParentPath(String parentPath) {
        this.fields.put(GroupField.PARENT_PATH, (Serializable)((Object)parentPath));
    }

    public GroupCreator setDisplayName(String displayName) {
        this.fields.put(GroupField.DISPLAY_NAME, (Serializable)((Object)displayName));
        return this;
    }

    public GroupCreator setDescription(String description) {
        this.fields.put(GroupField.DESCRIPTION, (Serializable)((Object)description));
        return this;
    }

    @Deprecated
    public GroupCreator setIconName(String iconName) {
        return this;
    }

    @Deprecated
    public GroupCreator setIconPath(String iconPath) {
        return this;
    }

    public GroupCreator setIcon(String filename, byte[] content) {
        this.fields.put(GroupField.ICON_FILENAME, (Serializable)((Object)filename));
        this.fields.put(GroupField.ICON_CONTENT, (Serializable)content);
        return this;
    }

    public Map<GroupField, Serializable> getFields() {
        return this.fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupCreator that = (GroupCreator)o;
        return Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.fields);
    }

    public String toString() {
        return "GroupCreator{fields=" + this.fields + '}';
    }

    public static enum GroupField {
        NAME,
        DISPLAY_NAME,
        DESCRIPTION,
        ICON_NAME,
        ICON_PATH,
        PARENT_PATH,
        ICON_FILENAME,
        ICON_CONTENT;

    }
}

